/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.shiro;

import cn.dreampie.web.ReturnKit;
import com.jfinal.kit.JsonKit;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiroLogoutFilter
extends AdviceFilter {
    private static final Logger log = LoggerFactory.getLogger(ShiroLogoutFilter.class);
    public static final String DEFAULT_REDIRECT_URL = "/";
    private String redirectUrl = "/";
    private Map<String, String> redirectUrlMap;

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        String redirectUrl = this.getRealRedirectUrl(request, subject);
        try {
            if (subject != null && subject.getPrincipal() != null) {
                subject.logout();
            }
        }
        catch (SessionException ise) {
            log.debug("Encountered session exception during logout.  This can generally safely be ignored.", (Throwable)ise);
        }
        if (ReturnKit.isJson((HttpServletRequest)((HttpServletRequest)request))) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            Enumeration attrNames = request.getAttributeNames();
            String name = "";
            while (attrNames.hasMoreElements()) {
                name = (String)attrNames.nextElement();
                parameterMap.put(name, request.getAttribute(name));
            }
            PrintWriter writer = null;
            try {
                response.setCharacterEncoding("UTF-8");
                writer = response.getWriter();
                writer.write(JsonKit.toJson(parameterMap));
                writer.flush();
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        } else {
            this.issueRedirect(request, response, redirectUrl);
        }
        return false;
    }

    protected Subject getSubject(ServletRequest request, ServletResponse response) {
        return SecurityUtils.getSubject();
    }

    protected void issueRedirect(ServletRequest request, ServletResponse response, String redirectUrl) throws Exception {
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)redirectUrl);
    }

    protected String getRedirectUrl(ServletRequest request, ServletResponse response, Subject subject) {
        return this.getRedirectUrl();
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public Map<String, String> getRedirectUrlMap() {
        return this.redirectUrlMap;
    }

    public void setRedirectUrlMap(Map<String, String> redirectUrlMap) {
        this.redirectUrlMap = redirectUrlMap;
    }

    public String getRealRedirectUrl(ServletRequest request, Subject subject) {
        String redirectUrl = "";
        if (this.redirectUrlMap != null) {
            for (String key : this.redirectUrlMap.keySet()) {
                if (!subject.hasRole(key)) continue;
                redirectUrl = this.redirectUrlMap.get(key);
                break;
            }
        }
        if (redirectUrl.isEmpty()) {
            redirectUrl = this.getRedirectUrl();
        }
        return redirectUrl;
    }
}

