/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.shiro;

import cn.dreampie.shiro.ShiroAuthenticatingFilter;
import cn.dreampie.shiro.core.SubjectKit;
import cn.dreampie.web.ReturnKit;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiroFormAuthenticationFilter
extends ShiroAuthenticatingFilter {
    public static final String DEFAULT_ERROR_KEY_ATTRIBUTE_NAME = "shiroLoginFailure";
    public static final String DEFAULT_USERNAME_PARAM = "username";
    public static final String DEFAULT_PASSWORD_PARAM = "password";
    public static final String DEFAULT_REMEMBER_ME_PARAM = "rememberMe";
    private static final Logger log = LoggerFactory.getLogger(ShiroFormAuthenticationFilter.class);
    private String usernameParam = "username";
    private String passwordParam = "password";
    private String rememberMeParam = "rememberMe";
    private String failureKeyAttribute = "shiroLoginFailure";

    public ShiroFormAuthenticationFilter() {
        this.setLoginUrl("/login");
    }

    public void setUseCaptcha(boolean useCaptcha) {
        ShiroFormAuthenticationFilter.useCaptcha = useCaptcha;
    }

    @Override
    public void setLoginUrlMap(Map<String, String> loginUrlMap) {
        if (log.isTraceEnabled()) {
            log.trace("Adding more login url to applied paths.");
        }
        this.setUrlPath(loginUrlMap, this.getLoginUrlMap());
        super.setLoginUrlMap(loginUrlMap);
    }

    @Override
    public void setSuccessUrlMap(Map<String, String> successUrlMap) {
        if (log.isTraceEnabled()) {
            log.trace("Adding more success url to applied paths.");
        }
        this.setUrlPath(successUrlMap, this.getSuccessUrlMap());
        super.setSuccessUrlMap(successUrlMap);
    }

    @Override
    public void setFailureUrlMap(Map<String, String> failureUrlMap) {
        if (log.isTraceEnabled()) {
            log.trace("Adding more success url to applied paths.");
        }
        this.setUrlPath(failureUrlMap, this.getSuccessUrlMap());
        super.setFailureUrlMap(failureUrlMap);
    }

    private void setUrlPath(Map<String, String> now, Map<String, String> previous) {
        if (previous != null) {
            for (String key : previous.keySet()) {
                this.appliedPaths.remove(previous.get(key));
            }
        }
        if (now != null) {
            for (String key : now.keySet()) {
                this.appliedPaths.put(now.get(key), null);
            }
        }
    }

    @Override
    public void setLoginUrl(String loginUrl) {
        String previous = this.getLoginUrl();
        if (previous != null) {
            this.appliedPaths.remove(previous);
        }
        super.setLoginUrl(loginUrl);
        if (log.isTraceEnabled()) {
            log.trace("Adding login url to applied paths.");
        }
        this.appliedPaths.put(this.getLoginUrl(), null);
    }

    public String getUsernameParam() {
        return this.usernameParam;
    }

    public void setUsernameParam(String usernameParam) {
        this.usernameParam = usernameParam;
    }

    public String getPasswordParam() {
        return this.passwordParam;
    }

    public void setPasswordParam(String passwordParam) {
        this.passwordParam = passwordParam;
    }

    public String getRememberMeParam() {
        return this.rememberMeParam;
    }

    public void setRememberMeParam(String rememberMeParam) {
        this.rememberMeParam = rememberMeParam;
    }

    public String getFailureKeyAttribute() {
        return this.failureKeyAttribute;
    }

    public void setFailureKeyAttribute(String failureKeyAttribute) {
        this.failureKeyAttribute = failureKeyAttribute;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                if (log.isTraceEnabled()) {
                    log.trace("Login submission detected.  Attempting to execute login.");
                }
                return this.executeLogin(request, response);
            }
            if (log.isTraceEnabled()) {
                log.trace("Login page view.");
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace("Attempting to access a path which requires authentication.  Forwarding to the Authentication url [" + this.getLoginUrl() + "]");
        }
        this.saveRequestAndRedirectToLogin(request, response);
        return false;
    }

    protected boolean isLoginSubmission(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && WebUtils.toHttp((ServletRequest)request).getMethod().equalsIgnoreCase("POST");
    }

    @Override
    protected UsernamePasswordToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        String captcha = this.getCaptcha(request);
        return this.createToken(username, password, captcha, request, response);
    }

    @Override
    protected boolean isRememberMe(ServletRequest request) {
        return WebUtils.isTrue((ServletRequest)request, (String)this.getRememberMeParam());
    }

    @Override
    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        boolean returnJson = ReturnKit.isJson((HttpServletRequest)((HttpServletRequest)request));
        this.clearFailureAttribute(request, response, returnJson);
        this.issueSuccessRedirect(request, response, returnJson);
        return false;
    }

    @Override
    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) throws Exception {
        boolean returnJson = ReturnKit.isJson((HttpServletRequest)((HttpServletRequest)request));
        this.setFailureAttribute(request, response, returnJson, e);
        this.issueFailureRedirect(request, response, returnJson);
        return !returnJson;
    }

    protected void setFailureAttribute(ServletRequest request, ServletResponse response, boolean returnJson, AuthenticationException ae) {
        String className = ae.getClass().getSimpleName();
        if (returnJson) {
            request.setAttribute(this.getFailureKeyAttribute(), (Object)className);
        } else {
            Session session = this.getSubject(request, response).getSession();
            session.setAttribute((Object)this.getFailureKeyAttribute(), (Object)className);
        }
    }

    protected void clearFailureAttribute(ServletRequest request, ServletResponse response, boolean returnJson) {
        if (returnJson) {
            request.setAttribute("user", SubjectKit.getUser());
            request.removeAttribute(this.getFailureKeyAttribute());
        } else {
            Session session = this.getSubject(request, response).getSession();
            session.removeAttribute((Object)this.getFailureKeyAttribute());
            session.removeAttribute((Object)this.usernameParam);
        }
    }

    protected String getUsername(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getUsernameParam());
    }

    protected String getPassword(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getPasswordParam());
    }
}

