/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.shiro;

import cn.dreampie.shiro.ShiroAccessControlFilter;
import com.jfinal.kit.JsonKit;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShiroAuthenticationFilter
extends ShiroAccessControlFilter {
    public static final String DEFAULT_SUCCESS_URL = "/";
    private String successUrl = "/";
    private Map<String, String> successUrlMap;

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public Map<String, String> getSuccessUrlMap() {
        return this.successUrlMap;
    }

    public void setSuccessUrlMap(Map<String, String> successUrlMap) {
        this.successUrlMap = successUrlMap;
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Subject subject = this.getSubject(request, response);
        return subject.isAuthenticated();
    }

    protected void issueSuccessRedirect(ServletRequest request, ServletResponse response, boolean returnJson) throws Exception {
        this.dynaRedirect(request, response, this.getRealSuccessUrl(request, response), returnJson);
    }

    protected void issueFailureRedirect(ServletRequest request, ServletResponse response, boolean returnJson) throws Exception {
        this.dynaRedirect(request, response, this.getRealFailureUrl(request), returnJson);
    }

    protected void dynaRedirect(ServletRequest request, ServletResponse response, String url, boolean returnJson) throws Exception {
        if (returnJson) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            Enumeration attrNames = request.getAttributeNames();
            String name = "";
            while (attrNames.hasMoreElements()) {
                name = (String)attrNames.nextElement();
                parameterMap.put(name, request.getAttribute(name));
            }
            PrintWriter writer = null;
            try {
                response.setCharacterEncoding("UTF-8");
                writer = response.getWriter();
                writer.write(JsonKit.toJson(parameterMap));
                writer.flush();
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        } else {
            WebUtils.redirectToSavedRequest((ServletRequest)request, (ServletResponse)response, (String)url);
        }
    }

    String getRealSuccessUrl(ServletRequest request, ServletResponse response) {
        String successUrl = "";
        if (this.successUrlMap != null) {
            Subject subject = this.getSubject(request, response);
            for (String key : this.successUrlMap.keySet()) {
                if (!subject.hasRole(key)) continue;
                successUrl = this.successUrlMap.get(key);
                break;
            }
        }
        if (successUrl.isEmpty()) {
            successUrl = this.getSuccessUrl();
        }
        return successUrl;
    }
}

