package cn.dreampie.shiro.freemarker;

import freemarker.core.Environment;
import freemarker.log.Logger;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;

import java.io.IOException;
import java.util.Map;


/**
 * JSP tag that renders the tag body if the current user <em>is not</em> known to the system, either because they
 * haven't logged in yet, or because they have no 'RememberMe' identity.
 * <p/>
 * <p>The logically opposite tag of this one is the {@link cn.dreampie.common.plugin.shiro.freemarker.UserTag}.  Please read that class's JavaDoc as it explains
 * more about the differences between Authenticated/Unauthenticated and User/Guest semantic differences.
 * <p/>
 * <p>Equivalent to {@link org.apache.shiro.web.tags.GuestTag}</p>
 *
 * @since 0.9
 */
public class GuestTag extends SecureTag {
  private static final Logger log = Logger.getLogger("AuthenticatedTag");

  @Override
  public void render(Environment env, Map params, TemplateDirectiveBody body) throws IOException, TemplateException {
    if (getSubject() == null || getSubject().getPrincipal() == null) {
      if (log.isDebugEnabled()) {
        log.debug("Subject does not exist or does not have a known identity (aka 'principal').  " +
            "Tag body will be evaluated.");
      }

      renderBody(env, body);
    } else {
      if (log.isDebugEnabled()) {
        log.debug("Subject exists or has a known identity (aka 'principal').  " +
            "Tag body will not be evaluated.");
      }
    }
  }
//  String getName(Map params) {
//    return getParam(params, "name");
//  }
//
//  @Override
//  public void render(Environment env, Map params, TemplateDirectiveBody body) throws IOException, TemplateException {
//    boolean show = false;
//    //判断是否使用访客权限
//
//    show = (getSubject() == null || getSubject().getPrincipal() == null || !getSubject().isAuthenticated());
//
//    if (show) {
//      renderBody(env, body);
//    }
//  }
//
//  protected abstract boolean showTagBody(String roleName);
}
