/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.util.tree;

import cn.dreampie.common.util.tree.TreeNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TreeUtils {
    public static List toTree(List params) {
        List nodes = null;
        if (params.size() > 0) {
            Collections.sort(params, new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode rp1, TreeNode rp2) {
                    return Long.compare(rp1.getParentId(), rp2.getParentId());
                }
            });
            nodes = TreeUtils.toTree(params, ((TreeNode)params.get(0)).getParentId());
        }
        return nodes;
    }

    public static List toTreeLevel(List params, int level) {
        List nodes = null;
        if (params.size() > 0) {
            Collections.sort(params, new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode rp1, TreeNode rp2) {
                    return Long.compare(rp1.getParentId(), rp2.getParentId());
                }
            });
            nodes = TreeUtils.toTreeLevel(params, ((TreeNode)params.get(0)).getParentId(), level);
        }
        return nodes;
    }

    public static List toTree(List params, long pid) {
        ArrayList nodes = Lists.newArrayList();
        if (params != null && params.size() > 0) {
            TreeNode node = null;
            for (int i = 0; i < params.size(); ++i) {
                node = (TreeNode)params.get(i);
                if (node.getParentId() != pid) continue;
                nodes.add(node);
                params.remove(i);
                node.setChildren(TreeUtils.toTree(params, node.getId()));
                --i;
            }
        }
        return nodes;
    }

    public static List toTreeLevel(List params, long pid, int level) {
        ArrayList nodes = Lists.newArrayList();
        if (params != null && params.size() > 0) {
            TreeNode node = null;
            for (int i = 0; i < params.size(); ++i) {
                node = (TreeNode)params.get(i);
                if (node.getParentId() != pid) continue;
                nodes.add(node);
                params.remove(i);
                if (level > 1) {
                    node.setChildren(TreeUtils.toTreeLevel(params, node.getId(), --level));
                } else {
                    nodes.addAll(TreeUtils.toTreeLevel(params, node.getId(), --level));
                }
                ++level;
                --i;
            }
        }
        return nodes;
    }
}

