/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Pattern;

public class ValidateUtils {
    private static ValidateUtils validateUtils = new ValidateUtils();

    public static ValidateUtils me() {
        return validateUtils;
    }

    private ValidateUtils() {
    }

    public boolean match(String regex, String value) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(value).find();
    }

    public boolean match(String regex, int flags, String value) {
        Pattern pattern = Pattern.compile(regex, flags);
        return pattern.matcher(value).find();
    }

    public boolean isEmail(String value) {
        String check = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        return this.match(check, 2, value);
    }

    public boolean isMobile(String value) {
        String check = "^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1}))+\\d{8})$";
        return this.match(check, 2, value);
    }

    public boolean isTel(String value) {
        String check = "^\\d{3,4}-?\\d{7,9}$";
        return this.match(check, 2, value);
    }

    public boolean isPhone(String value) {
        String telcheck = "^\\d{3,4}-?\\d{7,9}$";
        String mobilecheck = "^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1}))+\\d{8})$";
        return this.match(telcheck, 2, value) || this.match(mobilecheck, 2, value);
    }

    public boolean isGeneral(String value) {
        String check = "^\\w+$";
        return this.match(check, 2, value);
    }

    public boolean isGeneral(String value, int min, int max) {
        String check = "^\\w{" + min + "," + max + "}$";
        return this.match(check, 2, value);
    }

    public boolean isBirthDay(String value) {
        String check = "(\\d{4})(/|-|\\.)(\\d{1,2})(/|-|\\.)(\\d{1,2})$";
        if (this.match(check, 2, value)) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            if (month < 1 || month > 12) {
                return false;
            }
            if (day < 1 || day > 31) {
                return false;
            }
            if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
                return false;
            }
            if (month == 2) {
                boolean isleap;
                boolean bl = isleap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
                if (day > 29 || day == 29 && !isleap) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isIdentityCard(String value) {
        String check = "(^\\d{15}$)|(^\\d{17}([0-9]|X)$)";
        return this.match(check, 2, value);
    }

    public boolean isZipCode(String value) {
        String check = "^[0-9]{6}$";
        return this.match(check, 2, value);
    }

    public boolean isMoney(String value) {
        String check = "^(\\d+(?:\\.\\d{1,2})?)$";
        return this.match(check, 2, value);
    }

    public boolean isNumber(String value) {
        String check = "^(\\+|\\-)?\\d+$";
        return this.match(check, 2, value);
    }

    public boolean isNumber(String value, int min, int max) {
        String check = "^(\\+|\\-)?\\d{" + min + "," + max + "}$";
        return this.match(check, 2, value);
    }

    public boolean isPositiveNumber(String value) {
        String check = "^\\d+$";
        return this.match(check, 2, value);
    }

    public boolean isPositiveNumber(String value, int min, int max) {
        String check = "^\\d{" + min + "," + max + "}$";
        return this.match(check, 2, value);
    }

    public boolean isChinese(String value) {
        String check = "^[\\u2E80-\\u9FFF]+$";
        return this.match(check, 2, value);
    }

    public boolean isChinese(String value, int min, int max) {
        String check = "^[\\u2E80-\\u9FFF]{" + min + "," + max + "}$";
        return this.match(check, 2, value);
    }

    public boolean isString(String value) {
        String check = "^[\\u0391-\\uFFE5\\w]+$";
        return this.match(check, 2, value);
    }

    public boolean isString(String value, int min, int max) {
        String check = "^[\\u0391-\\uFFE5\\w]{" + min + "," + max + "}$";
        return this.match(check, 2, value);
    }

    public boolean isUUID(String value) {
        String check = "^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$";
        return this.match(check, 2, value);
    }

    public boolean isCardPrefix(String value) {
        String check = "^[A-Za-z]\\w{0,3}\\d{0,4}$";
        return this.match(check, 2, value);
    }

    public boolean isCard(String value) {
        String check = "^[A-Za-z]\\w{3}\\d{4}$";
        return this.match(check, 2, value);
    }

    public boolean isUsername(String value) {
        return this.isGeneral(value, 5, 18);
    }

    public boolean isPassword(String value) {
        return this.isGeneral(value, 5, 18);
    }

    public boolean isUrl(String value) {
        String check = "^((https?|ftp):\\/\\/)?(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$";
        return this.match(check, 2, value);
    }

    public boolean isDateTime(String value) {
        String check = "^(\\d{4})(/|-|\\.|\u5e74)(\\d{1,2})(/|-|\\.|\u6708)(\\d{1,2})(\u65e5)?(\\s+\\d{1,2}(:|\u65f6)\\d{1,2}(:|\u5206)?(\\d{1,2}(\u79d2)?)?)?$";
        return this.match(check, 2, value);
    }

    public boolean isNullOrEmpty(Object value) {
        return value instanceof Collection ? value == null || ((Collection)value).isEmpty() : (value instanceof String ? value == null || "".equals(value.toString().trim()) : value == null);
    }

    public boolean isLength(String value, int min, int max) {
        int length;
        int n = length = this.isNullOrEmpty(value) ? 0 : value.length();
        return length >= min && length <= max;
    }

    public boolean compareDate(String date1, String date2) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date d1 = sdf.parse(date1);
            Date d2 = sdf.parse(date2);
            return d1.compareTo(d2) > 0;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        String email = "sss@gmail.com";
        String phone = "18611351122";
        String general = "aa";
        String[] strs = new String[]{"http://www.13.com", "https://www.asdf.com.cn/asdf", "www.23.com", "http://www.123.com/tsf", "http://www.abc.com/ab:2525/a.asp", "http://www.123.com:2563/tsf/a.html?a=2&&b=abc", "http://www.aa.com/servlet", "http://ee.com/abcSerlvet?a=8&&b=asdf", "ftp://192.168.0.2:8080", "http://ww.ss.com/////", "http://ww.gg.cn/"};
        for (int i = 0; i < strs.length; ++i) {
            System.out.printf("%s --> %s%n", strs[i], ValidateUtils.me().isUrl(strs[i]));
        }
        System.out.println("--------------------------------");
        String check = "^((https?|ftp):\\/\\/)?(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$";
        Pattern pattern = Pattern.compile(check, 2);
        for (int i = 0; i < strs.length; ++i) {
            System.out.printf("%s --> %s%n", strs[i], pattern.matcher(strs[i]).find());
        }
        System.out.println("UUID:" + ValidateUtils.me().isUUID("ee706ee9-1658-43d0-bc1f-2db23cab4ab2"));
    }
}

