/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtils {
    private static final Logger logger = LoggerFactory.getLogger(CookieUtils.class);
    private static CookieUtils cookieUtils = new CookieUtils();

    private CookieUtils() {
    }

    public CookieUtils me() {
        return cookieUtils;
    }

    public void addCookieObj(HttpServletRequest request, HttpServletResponse response, String name, Object value, int expiry) {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            String cookieValue = baos.toString("ISO-8859-1");
            String encodedCookieValue = URLEncoder.encode(cookieValue, "UTF-8");
            this.addCookie(request, response, name, encodedCookieValue, expiry);
        }
        catch (Exception e) {
            logger.error("\u4fdd \u5b58\u5bf9\u8c61\u5230cookie\u51fa\u9519\uff1a " + e.getMessage());
        }
    }

    public Object getCookieObj(HttpServletRequest request, HttpServletResponse response, String name) {
        String cookieValue = this.getCookie(request, name);
        Object result = null;
        if (cookieValue != null && cookieValue.trim() != "") {
            try {
                String decoderCookieValue = URLDecoder.decode(cookieValue, "UTF-8");
                ByteArrayInputStream bais = new ByteArrayInputStream(decoderCookieValue.getBytes("ISO-8859-1"));
                ObjectInputStream ios = new ObjectInputStream(bais);
                result = ios.readObject();
                return result;
            }
            catch (Exception e) {
                logger.error(" \u4ece cookie\u4e2d\u89e3\u6790\u5bf9\u8c61\u51fa\u9519\uff1a " + e.getMessage());
            }
        }
        return result;
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int expiry) {
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Cookie[] cookies = request.getCookies();
        boolean existuser = false;
        if (cookies != null && cookies.length > 0) {
            StringBuilder cname = null;
            for (int i = 0; i < cookies.length; ++i) {
                cname = new StringBuilder(cookies[i].getName());
                if (!cname.toString().equalsIgnoreCase(name)) continue;
                existuser = true;
                cookies[i].setValue(value);
                cookies[i].setMaxAge(expiry);
                response.addCookie(cookies[i]);
                break;
            }
        }
        if (!existuser) {
            Cookie cookie = null;
            cookie = new Cookie(name, value);
            cookie.setSecure(false);
            cookie.setMaxAge(expiry);
            response.addCookie(cookie);
        }
    }

    public String getCookie(HttpServletRequest request, String name) {
        String result = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            StringBuilder cname = null;
            for (int i = 0; i < cookies.length; ++i) {
                cname = new StringBuilder(cookies[i].getName());
                if (!cname.toString().equalsIgnoreCase(name)) continue;
                result = cookies[i].getValue();
                break;
            }
        }
        if (result != null) {
            try {
                result = URLDecoder.decode(result, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void removeCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            StringBuilder cname = null;
            for (int i = 0; i < cookies.length; ++i) {
                cname = new StringBuilder(cookies[i].getName());
                if (!cname.toString().equalsIgnoreCase(name)) continue;
                cookies[i].setValue(null);
                cookies[i].setMaxAge(-1);
                response.addCookie(cookies[i]);
                break;
            }
        }
    }

    public void main(String[] args) {
        String re = "/controller".substring(0, "/controller".indexOf("controller"));
        System.out.print(re);
    }
}

