/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.tablebind;

import com.google.common.collect.Lists;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSearcherExt {
    protected static final Logger LOG = Logger.getLogger(ClassSearcherExt.class);
    private List<String> classpaths = Lists.newArrayList();
    private String classpath = PathKit.getRootClassPath();
    private boolean includeAllJarsInLib = false;
    private List<String> includeJars = Lists.newArrayList();
    private String libDir = PathKit.getWebRootPath() + File.separator + "WEB-INF" + File.separator + "lib";
    private Class target;

    private static <T> List<Class<? extends T>> extraction(Class<T> clazz, List<String> classFileList) {
        ArrayList classList = Lists.newArrayList();
        for (String classFile : classFileList) {
            Class classInFile = (Class)Reflect.on((String)classFile).get();
            if (!clazz.isAssignableFrom(classInFile) || clazz == classInFile) continue;
            classList.add(classInFile);
        }
        return classList;
    }

    public static ClassSearcherExt of(Class target) {
        return new ClassSearcherExt(target);
    }

    private static List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList classFiles = Lists.newArrayList();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            LOG.error("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] filelist = baseDir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                if (readfile.isDirectory()) {
                    classFiles.addAll(ClassSearcherExt.findFiles(baseDirName + File.separator + filelist[i], targetFileName));
                    continue;
                }
                tempName = readfile.getName();
                if (!ClassSearcherExt.wildcardMatch(targetFileName, tempName)) continue;
                String tem = readfile.getAbsoluteFile().toString().replaceAll("\\\\", "/");
                String classname = tem.substring(tem.indexOf("/classes") + "/classes".length() + 1, tem.indexOf(".class"));
                classFiles.add(classname.replaceAll("/", "."));
            }
        }
        return classFiles;
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ClassSearcherExt.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public ClassSearcherExt(Class target) {
        this.target = target;
    }

    public ClassSearcherExt injars(List<String> jars) {
        if (jars != null) {
            this.includeJars.addAll(jars);
        }
        return this;
    }

    public ClassSearcherExt inJars(String ... jars) {
        if (jars != null) {
            for (String jar : jars) {
                this.includeJars.add(jar);
            }
        }
        return this;
    }

    public ClassSearcherExt classpath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    public ClassSearcherExt classpaths(String ... classpaths) {
        String rootPath = this.classpath;
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if (classpaths != null) {
            for (String classpath : classpaths) {
                this.classpaths.add(rootPath + classpath.replaceAll("\\.", "/"));
            }
        }
        return this;
    }

    public ClassSearcherExt classpaths(List<String> classpaths) {
        String rootPath = this.classpath;
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if (classpaths != null) {
            for (String classpath : classpaths) {
                this.classpaths.add(rootPath + classpath.replaceAll("\\.", "/"));
            }
        }
        return this;
    }

    public <T> List<Class<? extends T>> search() {
        if (this.classpaths.size() <= 0) {
            List<String> classFileList = ClassSearcherExt.findFiles(this.classpath, "*.class");
            classFileList.addAll(this.findjarFiles(this.libDir, this.includeJars));
            return ClassSearcherExt.extraction(this.target, classFileList);
        }
        ArrayList classFileList = Lists.newArrayList();
        for (String classpath : this.classpaths) {
            classFileList.addAll(ClassSearcherExt.findFiles(classpath, "*.class"));
            classFileList.addAll(this.findjarFiles(this.libDir, this.includeJars));
        }
        return ClassSearcherExt.extraction(this.target, classFileList);
    }

    private List<String> findjarFiles(String baseDirName, final List<String> includeJars) {
        ArrayList classFiles = Lists.newArrayList();
        try {
            File baseDir = new File(baseDirName);
            if (!baseDir.exists() || !baseDir.isDirectory()) {
                LOG.error("file serach error\uff1a" + baseDirName + " is not a dir\uff01");
            } else {
                String[] filelist = baseDir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return ClassSearcherExt.this.includeAllJarsInLib || includeJars.contains(name);
                    }
                });
                for (int i = 0; i < filelist.length; ++i) {
                    JarFile localJarFile = new JarFile(new File(baseDirName + File.separator + filelist[i]));
                    Enumeration<JarEntry> entries = localJarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        if (jarEntry.isDirectory() || !entryName.endsWith(".class")) continue;
                        String className = entryName.replaceAll("/", ".").substring(0, entryName.length() - 6);
                        classFiles.add(className);
                    }
                    localJarFile.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classFiles;
    }

    public ClassSearcherExt includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }

    public ClassSearcherExt libDir(String libDir) {
        this.libDir = libDir;
        return this;
    }
}

