/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.tablebind;

import cn.dreampie.common.plugin.tablebind.ClassSearcherExt;
import com.google.common.collect.Lists;
import com.jfinal.ext.plugin.tablebind.INameStyle;
import com.jfinal.ext.plugin.tablebind.SimpleNameStyles;
import com.jfinal.ext.plugin.tablebind.TableBind;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Logger;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.Model;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoMultiSourceTableBindPlugin
extends ActiveRecordPlugin {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private List<Class<? extends Model>> excludeClasses = Lists.newArrayList();
    private List<Class<? extends Model>> includeClasses = Lists.newArrayList();
    private List<String> includeClassPaths = Lists.newArrayList();
    private List<String> includeJars = Lists.newArrayList();
    private boolean autoScan = false;
    private boolean includeAllJarsInLib;
    private INameStyle nameStyle;

    public AutoMultiSourceTableBindPlugin(DataSource dataSource) {
        this(dataSource, SimpleNameStyles.DEFAULT);
    }

    public AutoMultiSourceTableBindPlugin(DataSource dataSource, INameStyle nameStyle) {
        super(dataSource);
        this.nameStyle = nameStyle;
    }

    public AutoMultiSourceTableBindPlugin(IDataSourceProvider dataSourceProvider) {
        this(dataSourceProvider, SimpleNameStyles.DEFAULT);
    }

    public AutoMultiSourceTableBindPlugin(IDataSourceProvider dataSourceProvider, INameStyle nameStyle) {
        super(dataSourceProvider);
        this.nameStyle = nameStyle;
    }

    public AutoMultiSourceTableBindPlugin(String dataSourceName, IDataSourceProvider dataSourceProvider, INameStyle nameStyle) {
        super(dataSourceName, dataSourceProvider);
        this.nameStyle = nameStyle;
    }

    public AutoMultiSourceTableBindPlugin addExcludeClasses(Class<? extends Model> ... clazzes) {
        for (Class<? extends Model> clazz : clazzes) {
            this.excludeClasses.add(clazz);
        }
        return this;
    }

    public AutoMultiSourceTableBindPlugin addExcludeClasses(List<Class<? extends Model>> clazzes) {
        if (clazzes != null) {
            this.excludeClasses.addAll(clazzes);
        }
        return this;
    }

    public AutoMultiSourceTableBindPlugin addIncludeClasses(Class<? extends Model> ... clazzes) {
        for (Class<? extends Model> clazz : clazzes) {
            this.includeClasses.add(clazz);
        }
        return this;
    }

    public AutoMultiSourceTableBindPlugin addIncludeClasses(List<Class<? extends Model>> clazzes) {
        if (clazzes != null) {
            this.includeClasses.addAll(clazzes);
        }
        return this;
    }

    public AutoMultiSourceTableBindPlugin addIncludePaths(String ... paths) {
        for (String path : paths) {
            this.includeClassPaths.add(path);
        }
        return this;
    }

    public AutoMultiSourceTableBindPlugin addExcludePaths(String ... paths) {
        List clazzes = ClassSearcherExt.of(Model.class).classpaths(paths).search();
        for (Class clazz : clazzes) {
            this.excludeClasses.add(clazz);
        }
        return this;
    }

    public AutoMultiSourceTableBindPlugin addJars(List<String> jars) {
        if (jars != null) {
            this.includeJars.addAll(jars);
        }
        return this;
    }

    public AutoMultiSourceTableBindPlugin addJars(String ... jars) {
        if (jars != null) {
            for (String jar : jars) {
                this.includeJars.add(jar);
            }
        }
        return this;
    }

    public boolean start() {
        if (this.includeClasses.size() <= 0) {
            this.includeClasses = ClassSearcherExt.of(Model.class).classpaths(this.includeClassPaths).injars(this.includeJars).includeAllJarsInLib(this.includeAllJarsInLib).search();
        }
        TableBind tb = null;
        for (Class<? extends Model> modelClass : this.includeClasses) {
            String tableName;
            if (this.excludeClasses.contains(modelClass)) continue;
            tb = modelClass.getAnnotation(TableBind.class);
            if (tb == null) {
                if (!this.autoScan) continue;
                tableName = this.nameStyle.name(modelClass.getSimpleName());
                this.addMapping(tableName, modelClass);
                this.log.debug("addMapping(" + tableName + ", " + modelClass.getName() + ")");
                continue;
            }
            tableName = tb.tableName();
            if (StrKit.notBlank((String)tb.pkName())) {
                this.addMapping(tableName, tb.pkName(), modelClass);
                this.log.debug("addMapping(" + tableName + ", " + tb.pkName() + "," + modelClass.getName() + ")");
                continue;
            }
            this.addMapping(tableName, modelClass);
            this.log.debug("addMapping(" + tableName + ", " + modelClass.getName() + ")");
        }
        return super.start();
    }

    public boolean stop() {
        return super.stop();
    }

    public AutoMultiSourceTableBindPlugin autoScan(boolean autoScan) {
        this.autoScan = autoScan;
        return this;
    }

    public AutoMultiSourceTableBindPlugin includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }
}

