/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.sqlinxml;

import cn.dreampie.common.plugin.sqlinxml.SqlGroup;
import cn.dreampie.common.plugin.sqlinxml.SqlItem;
import cn.dreampie.common.plugin.sqlinxml.SqlRoot;
import com.jfinal.ext.kit.JaxbKit;
import com.jfinal.log.Logger;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlKit {
    protected static final Logger LOG = Logger.getLogger(SqlKit.class);
    private static Map<String, String> sqlMap;

    public static String sql(String groupNameAndsqlId) {
        if (sqlMap == null) {
            throw new NullPointerException("SqlInXmlPlugin not start");
        }
        return sqlMap.get(groupNameAndsqlId);
    }

    static void clearSqlMap() {
        sqlMap.clear();
    }

    static void init() {
        sqlMap = new HashMap<String, String>();
        SqlKit.loadFileList(SqlKit.class.getClassLoader().getResource("").getFile());
        LOG.debug("sqlMap" + sqlMap);
    }

    public static void loadFileList(String strPath) {
        ArrayList<File> files = new ArrayList<File>();
        File dir = new File(strPath);
        File[] dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith("sql") || pathname.getName().endsWith("sql.xml");
            }
        });
        if (dirs == null) {
            return;
        }
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].isDirectory()) {
                SqlKit.loadFileList(dirs[i].getAbsolutePath());
                continue;
            }
            if (!dirs[i].getName().endsWith("sql.xml")) continue;
            files.add(dirs[i]);
        }
        SqlKit.loadFiles(files);
    }

    private static void loadFiles(List<File> files) {
        for (File xmlfile : files) {
            SqlRoot root = (SqlRoot)JaxbKit.unmarshal((File)xmlfile, SqlRoot.class);
            for (SqlGroup sqlGroup : root.sqlGroups) {
                String name = sqlGroup.name;
                if (name == null || name.trim().equals("")) {
                    name = xmlfile.getName();
                }
                for (SqlItem sqlItem : sqlGroup.sqlItems) {
                    sqlMap.put(name + "." + sqlItem.id, sqlItem.value);
                }
            }
        }
    }
}

