/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.shiro.plugin;

import cn.dreampie.common.plugin.shiro.plugin.AuthenticatedAuthzHandler;
import cn.dreampie.common.plugin.shiro.plugin.AuthzHandler;
import cn.dreampie.common.plugin.shiro.plugin.ClearShiro;
import cn.dreampie.common.plugin.shiro.plugin.CompositeAuthzHandler;
import cn.dreampie.common.plugin.shiro.plugin.GuestAuthzHandler;
import cn.dreampie.common.plugin.shiro.plugin.JdbcAuthzService;
import cn.dreampie.common.plugin.shiro.plugin.PermissionAuthzHandler;
import cn.dreampie.common.plugin.shiro.plugin.RoleAuthzHandler;
import cn.dreampie.common.plugin.shiro.plugin.ShiroKit;
import cn.dreampie.common.plugin.shiro.plugin.UserAuthzHandler;
import com.jfinal.config.Routes;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Controller;
import com.jfinal.plugin.IPlugin;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiroPlugin
implements IPlugin {
    private static final String SLASH = "/";
    private static final Class<? extends Annotation>[] AUTHZ_ANNOTATION_CLASSES = new Class[]{RequiresPermissions.class, RequiresRoles.class, RequiresUser.class, RequiresGuest.class, RequiresAuthentication.class};
    private final Routes routes;
    private JdbcAuthzService jdbcAuthzService;

    public ShiroPlugin(Routes routes) {
        this.routes = routes;
    }

    public ShiroPlugin(Routes routes, JdbcAuthzService jdbcAuthzService) {
        this.routes = routes;
        this.jdbcAuthzService = jdbcAuthzService;
    }

    public boolean stop() {
        return true;
    }

    public boolean start() {
        Set<String> excludedMethodName = this.buildExcludedMethodName();
        ConcurrentHashMap<String, AuthzHandler> authzMaps = new ConcurrentHashMap<String, AuthzHandler>();
        for (Map.Entry entry : this.routes.getEntrySet()) {
            Method[] methods;
            Class controllerClass = (Class)entry.getValue();
            String controllerKey = (String)entry.getKey();
            List<Annotation> controllerAnnotations = this.getAuthzAnnotations(controllerClass);
            for (Method method : methods = controllerClass.getMethods()) {
                List<Annotation> methodAnnotations;
                AuthzHandler authzHandler;
                if (excludedMethodName.contains(method.getName()) || method.getParameterTypes().length != 0 || this.isClearShiroAnnotationPresent(method) || (authzHandler = this.createAuthzHandler(controllerAnnotations, methodAnnotations = this.getAuthzAnnotations(method))) == null) continue;
                String actionKey = this.createActionKey(controllerClass, method, controllerKey);
                authzMaps.put(actionKey, authzHandler);
            }
        }
        Map<String, AuthzHandler> authzJdbcMaps = null;
        if (this.jdbcAuthzService != null) {
            authzJdbcMaps = this.jdbcAuthzService.getJdbcAuthz();
        }
        ShiroKit.init(authzMaps, authzJdbcMaps);
        return true;
    }

    private Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>();
        for (Method m : methods = Controller.class.getMethods()) {
            if (m.getParameterTypes().length != 0) continue;
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }

    private AuthzHandler createAuthzHandler(List<Annotation> controllerAnnotations, List<Annotation> methodAnnotations) {
        if (controllerAnnotations.size() == 0 && methodAnnotations.size() == 0) {
            return null;
        }
        ArrayList<AuthzHandler> authzHandlers = new ArrayList<AuthzHandler>(5);
        for (int index = 0; index < 5; ++index) {
            authzHandlers.add(null);
        }
        this.scanAnnotation(authzHandlers, controllerAnnotations);
        this.scanAnnotation(authzHandlers, methodAnnotations);
        ArrayList<AuthzHandler> finalAuthzHandlers = new ArrayList<AuthzHandler>();
        for (AuthzHandler a : authzHandlers) {
            if (a == null) continue;
            finalAuthzHandlers.add(a);
        }
        authzHandlers = null;
        if (finalAuthzHandlers.size() > 1) {
            return new CompositeAuthzHandler(finalAuthzHandlers);
        }
        return (AuthzHandler)finalAuthzHandlers.get(0);
    }

    private void scanAnnotation(List<AuthzHandler> authzArray, List<Annotation> annotations) {
        if (null == annotations || 0 == annotations.size()) {
            return;
        }
        for (Annotation a : annotations) {
            if (a instanceof RequiresRoles) {
                authzArray.set(0, new RoleAuthzHandler(a));
                continue;
            }
            if (a instanceof RequiresPermissions) {
                authzArray.set(1, new PermissionAuthzHandler(a));
                continue;
            }
            if (a instanceof RequiresAuthentication) {
                authzArray.set(2, AuthenticatedAuthzHandler.me());
                continue;
            }
            if (a instanceof RequiresUser) {
                authzArray.set(3, UserAuthzHandler.me());
                continue;
            }
            if (!(a instanceof RequiresGuest)) continue;
            authzArray.set(4, GuestAuthzHandler.me());
        }
    }

    private String createActionKey(Class<? extends Controller> controllerClass, Method method, String controllerKey) {
        String methodName = method.getName();
        String actionKey = "";
        ActionKey ak = method.getAnnotation(ActionKey.class);
        if (ak != null) {
            actionKey = ak.value().trim();
            if ("".equals(actionKey)) {
                throw new IllegalArgumentException(controllerClass.getName() + "." + methodName + "(): The argument of ActionKey can not be blank.");
            }
            if (!actionKey.startsWith(SLASH)) {
                actionKey = SLASH + actionKey;
            }
        } else {
            actionKey = methodName.equals("index") ? controllerKey : (controllerKey.equals(SLASH) ? SLASH + methodName : controllerKey + SLASH + methodName);
        }
        return actionKey;
    }

    private List<Annotation> getAuthzAnnotations(Method method) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Class<? extends Annotation> annClass : AUTHZ_ANNOTATION_CLASSES) {
            Annotation a = method.getAnnotation(annClass);
            if (a == null) continue;
            annotations.add(a);
        }
        return annotations;
    }

    private List<Annotation> getAuthzAnnotations(Class<? extends Controller> targetClass) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Class<? extends Annotation> annClass : AUTHZ_ANNOTATION_CLASSES) {
            Annotation a = targetClass.getAnnotation(annClass);
            if (a == null) continue;
            annotations.add(a);
        }
        return annotations;
    }

    private boolean isClearShiroAnnotationPresent(Method method) {
        ClearShiro a = method.getAnnotation(ClearShiro.class);
        return a != null;
    }
}

