/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.shiro.plugin;

import cn.dreampie.common.plugin.shiro.plugin.AuthzHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiroKit {
    private static ConcurrentMap<String, AuthzHandler> authzMaps = null;
    private static Map<String, AuthzHandler> authzJdbcMaps = null;
    public static AntPathMatcher antPathMatcher = new AntPathMatcher();

    private ShiroKit() {
    }

    static void init(ConcurrentMap<String, AuthzHandler> amaps, Map<String, AuthzHandler> jmaps) {
        authzMaps = amaps;
        authzJdbcMaps = jmaps;
    }

    static AuthzHandler getAuthzHandler(String actionKey) {
        return (AuthzHandler)authzMaps.get(actionKey);
    }

    static List<AuthzHandler> getJdbcAuthzHandler(HttpServletRequest request) {
        ArrayList<AuthzHandler> result = new ArrayList<AuthzHandler>();
        String url = WebUtils.getPathWithinApplication((HttpServletRequest)request);
        for (String key : authzJdbcMaps.keySet()) {
            if (!antPathMatcher.match(key, url)) continue;
            result.add(authzJdbcMaps.get(key));
        }
        return result;
    }

    static List<AuthzHandler> getAuthzHandler(HttpServletRequest request, String actionKey) {
        List<AuthzHandler> result = ShiroKit.getJdbcAuthzHandler(request);
        AuthzHandler ah = ShiroKit.getAuthzHandler(actionKey);
        if (ah != null) {
            result.add(ah);
        }
        return result;
    }
}

