/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.shiro.freemarker;

import cn.dreampie.common.model.User;
import cn.dreampie.common.plugin.shiro.freemarker.SecureTag;
import freemarker.core.Environment;
import freemarker.log.Logger;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Map;

public class PrincipalTag
extends SecureTag {
    static final Logger log = Logger.getLogger((String)"PrincipalTag");

    String getType(Map params) {
        return this.getParam(params, "type");
    }

    String getProperty(Map params) {
        return this.getParam(params, "property");
    }

    public void render(Environment env, Map params, TemplateDirectiveBody body) throws IOException, TemplateException {
        String result = null;
        if (this.getSubject() != null) {
            String property;
            Object principal = this.getType(params) == null ? this.getSubject().getPrincipal() : this.getPrincipalFromClassName(params);
            result = principal != null ? ((property = this.getProperty(params)) == null ? (String)((User)((Object)principal)).get("full_name") : this.getPrincipalProperty(principal, property)) : "\u8bbf\u5ba2";
        }
        if (result != null) {
            try {
                env.getOut().write(result);
            }
            catch (IOException ex) {
                throw new TemplateException("Error writing [" + result + "] to Freemarker.", (Exception)ex, env);
            }
        }
    }

    Object getPrincipalFromClassName(Map params) {
        String type = this.getType(params);
        try {
            Class<?> cls = Class.forName(type);
            return this.getSubject().getPrincipals().oneByType(cls);
        }
        catch (ClassNotFoundException ex) {
            log.error("Unable to find class for name [" + type + "]", (Throwable)ex);
            return null;
        }
    }

    String getPrincipalProperty(Object principal, String property) throws TemplateModelException {
        try {
            User user;
            if (principal != null && (user = (User)((Object)principal)) != null && user.get(property) != null) {
                return String.valueOf(user.get(property));
            }
            return "";
        }
        catch (Exception ex) {
            throw new TemplateModelException("Error reading property [" + property + "] from principal of type [" + principal.getClass().getName() + "]", ex);
        }
    }
}

