/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.quartz;

import cn.dreampie.common.plugin.quartz.QuartzFactory;
import cn.dreampie.common.util.FileUtils;
import cn.dreampie.common.util.PropertiesUtils;
import cn.dreampie.common.util.TimeUtils;
import com.google.common.collect.Lists;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.IPlugin;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.joda.time.DateTime;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String config = "/quartz/quartz.properties";
    private String jobs = "/quartz/jobs.properties";
    private static List<String> startedJob = Lists.newArrayList();

    public QuartzPlugin() {
    }

    public QuartzPlugin(String config) {
        this.config = config;
    }

    public boolean start() {
        try {
            Properties properties = PropertiesUtils.me().loadPropertyFile(this.config);
            QuartzFactory.me().sf = new StdSchedulerFactory(properties);
            Scheduler sched = QuartzFactory.me().sf.getScheduler();
            sched.start();
            this.startPropertiesJobs();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean stop() {
        try {
            QuartzFactory.me().sf.getScheduler().shutdown();
            QuartzFactory.me().sf = null;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void startPropertiesJobs() {
        if (FileUtils.me().exist(PathKit.getRootClassPath() + this.jobs)) {
            Properties properties = PropertiesUtils.me().loadPropertyFile(this.jobs);
            Enumeration<Object> enums = properties.keys();
            while (enums.hasMoreElements()) {
                Class<?> clazz;
                String[] keyArr;
                String key = enums.nextElement() + "";
                if (!key.startsWith("job") || startedJob.contains((keyArr = key.split("\\."))[1])) continue;
                String jobClassKey = key.replace(keyArr[2], "class");
                String idKey = key.replace(keyArr[2], "id");
                String cronKey = key.replace(keyArr[2], "cron");
                String enable = key.replace(keyArr[2], "enable");
                if (!Boolean.valueOf(properties.getProperty(enable)).booleanValue()) continue;
                Integer id = Integer.parseInt(properties.getProperty(idKey));
                String jobCronExp = properties.getProperty(cronKey);
                String jobClassName = properties.getProperty(jobClassKey);
                try {
                    clazz = Class.forName(jobClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                QuartzFactory.me().startJobCron(TimeUtils.me().toString(DateTime.now()), id, keyArr[1], keyArr[1], jobCronExp, clazz);
                startedJob.add(keyArr[1]);
            }
        }
    }
}

