/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.patchca.service;

import cn.dreampie.common.plugin.patchca.background.BackgroundFactory;
import cn.dreampie.common.plugin.patchca.color.ColorFactory;
import cn.dreampie.common.plugin.patchca.filter.FilterFactory;
import cn.dreampie.common.plugin.patchca.font.FontFactory;
import cn.dreampie.common.plugin.patchca.service.Captcha;
import cn.dreampie.common.plugin.patchca.service.CaptchaService;
import cn.dreampie.common.plugin.patchca.text.renderer.TextRenderer;
import cn.dreampie.common.plugin.patchca.word.WordFactory;
import java.awt.image.BufferedImage;

public abstract class AbstractCaptchaService
implements CaptchaService {
    protected FontFactory fontFactory;
    protected WordFactory wordFactory;
    protected ColorFactory colorFactory;
    protected BackgroundFactory backgroundFactory;
    protected TextRenderer textRenderer;
    protected FilterFactory filterFactory;
    protected int width;
    protected int height;

    public void setFontFactory(FontFactory fontFactory) {
        this.fontFactory = fontFactory;
    }

    public void setWordFactory(WordFactory wordFactory) {
        this.wordFactory = wordFactory;
    }

    public void setColorFactory(ColorFactory colorFactory) {
        this.colorFactory = colorFactory;
    }

    public void setBackgroundFactory(BackgroundFactory backgroundFactory) {
        this.backgroundFactory = backgroundFactory;
    }

    public void setTextRenderer(TextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public FontFactory getFontFactory() {
        return this.fontFactory;
    }

    public WordFactory getWordFactory() {
        return this.wordFactory;
    }

    public ColorFactory getColorFactory() {
        return this.colorFactory;
    }

    public BackgroundFactory getBackgroundFactory() {
        return this.backgroundFactory;
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Captcha getCaptcha() {
        BufferedImage bufImage = new BufferedImage(this.width, this.height, 2);
        this.backgroundFactory.fillBackground(bufImage);
        String word = this.wordFactory.getNextWord();
        this.textRenderer.draw(word, bufImage, this.fontFactory, this.colorFactory);
        bufImage = this.filterFactory.applyFilters(bufImage);
        return new Captcha(word, bufImage);
    }
}

