/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.mail;

import cn.dreampie.common.exception.ValidateException;
import cn.dreampie.common.plugin.mail.MailerConf;
import cn.dreampie.common.util.PropertiesUtils;
import cn.dreampie.common.util.ValidateUtils;
import com.jfinal.plugin.IPlugin;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String config = "/application.properties";
    private Properties properties;
    private String host;
    private String sslport;
    private String timeout;
    private String port;
    private String ssl;
    private String tls;
    private String debug;
    private String user;
    private String password;
    private String name;
    private String from;
    private String encode;
    static MailerConf mailerConf;

    public MailerPlugin() {
    }

    public MailerPlugin(String config) {
        this.config = config;
    }

    public boolean start() {
        this.properties = PropertiesUtils.me().loadPropertyFile(this.config);
        this.host = this.properties.getProperty("smtp.host", "");
        if (ValidateUtils.me().isNullOrEmpty(this.host)) {
            throw new ValidateException("email host has not found!");
        }
        this.port = this.properties.getProperty("smtp.port", "");
        this.ssl = this.properties.getProperty("smtp.ssl", "false");
        this.sslport = this.properties.getProperty("smtp.sslport", "");
        this.timeout = this.properties.getProperty("smtp.timeout", "60000");
        this.tls = this.properties.getProperty("smtp.tls", "false");
        this.debug = this.properties.getProperty("smtp.debug", "false");
        this.user = this.properties.getProperty("smtp.user", "");
        if (ValidateUtils.me().isNullOrEmpty(this.user)) {
            throw new ValidateException("email user has not found!");
        }
        this.password = this.properties.getProperty("smtp.password", "");
        if (ValidateUtils.me().isNullOrEmpty(this.password)) {
            throw new ValidateException("email password has not found!");
        }
        this.name = this.properties.getProperty("smtp.name", "");
        this.from = this.properties.getProperty("smtp.from", "");
        if (ValidateUtils.me().isNullOrEmpty(this.from)) {
            throw new ValidateException("email from has not found!");
        }
        this.encode = this.properties.getProperty("smtp.encode", "UTF-8");
        mailerConf = new MailerConf(this.host, this.sslport, Integer.parseInt(this.timeout), this.port, Boolean.parseBoolean(this.ssl), Boolean.parseBoolean(this.tls), Boolean.parseBoolean(this.debug), this.user, this.password, this.name, this.from, this.encode);
        return true;
    }

    public boolean stop() {
        this.host = null;
        this.port = null;
        this.ssl = null;
        this.user = null;
        this.password = null;
        this.name = null;
        this.from = null;
        return true;
    }
}

