/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.db.tx;

import cn.dreampie.common.plugin.db.tx.AXTxConfig;
import cn.dreampie.common.plugin.db.tx.XAResult;
import cn.dreampie.common.plugin.db.tx.XAXid;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XATx
implements Interceptor {
    static int tid = 0;

    static Config[] getConfigWithAXTxConfigs(ActionInvocation ai) {
        AXTxConfig axTxConfig = ai.getMethod().getAnnotation(AXTxConfig.class);
        if (axTxConfig == null) {
            axTxConfig = ai.getController().getClass().getAnnotation(AXTxConfig.class);
        }
        if (axTxConfig != null) {
            Config[] configs = null;
            String[] names = axTxConfig.value();
            if (names != null && names.length > 0) {
                int length = names.length;
                configs = new Config[length];
                int i = 0;
                for (String conf : names) {
                    configs[i] = DbKit.getConfig((String)conf);
                    ++i;
                }
            }
            if (configs == null) {
                throw new RuntimeException("Config not found with AXTxConfig");
            }
            return configs;
        }
        return null;
    }

    protected int getTransactionLevel(Config config) {
        return config.getTransactionLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void intercept(ActionInvocation ai) {
        Config[] configs = XATx.getConfigWithAXTxConfigs(ai);
        XAXid xid = XAXid.uniqueXid(++tid);
        if (configs != null && configs.length > 0) {
            boolean r = true;
            XAResult[] xaResults = new XAResult[configs.length];
            int i = 0;
            Config[] configArray = configs;
            int n = configArray.length;
            for (int j = 0; j < n; ++i, ++j) {
                Config c = configArray[j];
                xaResults[i] = this.prepare(ai, c, xid);
                r = r && xaResults[i].getXaResource() != null;
            }
            if (r) {
                Connection connection = null;
                for (XAResult xaResult : xaResults) {
                    connection = (Connection)((Object)xaResult.getXaConnection());
                    try {
                        xaResult.getXaResource().commit(xid, false);
                    }
                    catch (XAException xae) {
                        throw new ActiveRecordException((Throwable)xae);
                    }
                    finally {
                        try {
                            if (connection != null && xaResult.getAutoCommit() != null) {
                                connection.setAutoCommit(xaResult.getAutoCommit());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (xaResult.isRemoveConnection()) {
                                xaResult.getConfig().removeThreadLocalConnection();
                            }
                        }
                    }
                }
            }
        }
        --tid;
    }

    private XAResult prepare(ActionInvocation ai, Config config, Xid xid) {
        XAConnection xaConn = null;
        Connection conn = config.getThreadLocalConnection();
        if (conn != null) {
            xaConn = (XAConnection)((Object)conn);
            try {
                if (conn.getTransactionIsolation() < this.getTransactionLevel(config)) {
                    conn.setTransactionIsolation(this.getTransactionLevel(config));
                }
                return new XAResult(config, this.prepareInvoke(xaConn, xid, ai), xaConn, null, false);
            }
            catch (SQLException e) {
                throw new ActiveRecordException((Throwable)e);
            }
            catch (XAException xae) {
                throw new ActiveRecordException((Throwable)xae);
            }
        }
        Boolean autoCommit = null;
        try {
            conn = config.getConnection();
            autoCommit = conn.getAutoCommit();
            config.setThreadLocalConnection(conn);
            conn.setTransactionIsolation(this.getTransactionLevel(config));
            conn.setAutoCommit(false);
            xaConn = (XAConnection)((Object)conn);
            return new XAResult(config, this.prepareInvoke(xaConn, xid, ai), xaConn, autoCommit, true);
        }
        catch (Exception e) {
            throw new ActiveRecordException((Throwable)e);
        }
    }

    private XAResource prepareInvoke(XAConnection xaconn, Xid xid, ActionInvocation ai) throws SQLException, XAException {
        XAResource xaRes = xaconn.getXAResource();
        xaRes.start(xid, 0);
        ai.invoke();
        xaRes.end(xid, 0x4000000);
        int result = xaRes.prepare(xid);
        if (result == 0) {
            return xaRes;
        }
        return null;
    }
}

