/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.coffeescript.compiler;

import cn.dreampie.common.plugin.coffeescript.compiler.AbstractCoffeeScript;
import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeCompiler;
import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeException;
import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoffeeScriptCompiler
extends AbstractCoffeeScript {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private CoffeeCompiler coffeeCompiler;
    protected File outputDirectory;
    private boolean compress;
    protected boolean watch = false;
    private int watchInterval = 1000;
    private String encoding;
    private boolean force;
    private File coffeeJs;
    private String nodeExecutable;
    private String outputFileFormat;
    private static final String FILE_NAME_FORMAT_PARAMETER_REGEX = "\\{fileName\\}";
    private String[] args;

    public void execute() throws CoffeeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sourceDirectory = " + this.sourceDirectory);
            this.logger.debug("outputDirectory = " + this.outputDirectory);
            this.logger.debug("includes = " + Arrays.toString(this.includes));
            this.logger.debug("excludes = " + Arrays.toString(this.excludes));
            this.logger.debug("force = " + this.force);
            this.logger.debug("coffeeJs = " + this.coffeeJs);
            this.logger.debug("skip = " + this.skip);
        }
        if (!this.skip) {
            if (this.watch) {
                this.logger.info("Watching " + this.sourceDirectory);
                if (this.force) {
                    this.force = false;
                    this.logger.info("Disabled the 'force' flag in watch mode.");
                }
                Thread.currentThread().setPriority(1);
                while (this.watch && !Thread.currentThread().isInterrupted()) {
                    this.executeInternal();
                    try {
                        Thread.sleep(this.watchInterval);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("interrupted");
                    }
                }
            } else {
                this.executeInternal();
            }
        } else {
            this.logger.info("Skipping plugin execution per configuration");
        }
    }

    private void executeInternal() throws CoffeeException {
        long start = System.currentTimeMillis();
        Object[] files = this.getIncludedFiles();
        if (files == null || files.length < 1) {
            this.logger.info("Nothing to compile - no COFFEE sources found");
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("included files = " + Arrays.toString(files));
            }
            Object coffeeCompiler = this.initCoffeeCompiler();
            this.compileIfChanged((String[])files, coffeeCompiler);
        }
    }

    private void compileIfChanged(String[] files, Object coffeeCompiler) throws CoffeeException {
        for (String file : files) {
            File output;
            File input = new File(this.sourceDirectory, file);
            this.buildContext.removeMessages(input);
            if (this.outputFileFormat != null) {
                file = this.outputFileFormat.replaceAll(FILE_NAME_FORMAT_PARAMETER_REGEX, file.replace(".coffee", ""));
            }
            if (!(output = new File(this.outputDirectory, file.replace(".coffee", ".js"))).getParentFile().exists() && !output.getParentFile().mkdirs()) {
                throw new CoffeeException("Cannot create output directory " + output.getParentFile());
            }
            try {
                CoffeeSource coffeeSource = new CoffeeSource(input);
                if (this.force || !output.exists() || output.lastModified() < coffeeSource.getLastModifiedIncludingImports()) {
                    long compilationStarted = System.currentTimeMillis();
                    this.logger.info("Compiling COFFEE source: " + file);
                    if (coffeeCompiler instanceof CoffeeCompiler) {
                        ((CoffeeCompiler)coffeeCompiler).compile(coffeeSource, output, this.force);
                    }
                    this.buildContext.refresh(output);
                    this.logger.info("Finished compilation to " + this.outputDirectory + " in " + (System.currentTimeMillis() - compilationStarted) + " ms");
                    continue;
                }
                if (this.watch) continue;
                this.logger.info("Bypassing COFFEE source: " + file + " (not modified)");
            }
            catch (IOException e) {
                throw new CoffeeException("Error while compiling COFFEE source: " + file, e);
            }
            catch (CoffeeException e) {
                String message = e.getMessage();
                if (StringUtils.isEmpty((String)message)) {
                    message = "Error compiling COFFEE source";
                }
                throw new CoffeeException("Error while compiling COFFEE source: " + file, e);
            }
        }
    }

    private Object initCoffeeCompiler() throws CoffeeException {
        if (this.coffeeCompiler == null) {
            CoffeeCompiler newCoffeeCompiler = new CoffeeCompiler();
            newCoffeeCompiler.setEncoding(this.encoding);
            newCoffeeCompiler.setOptionArgs(this.args);
            if (this.coffeeJs != null) {
                try {
                    newCoffeeCompiler.setCoffeeJs(this.coffeeJs.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new CoffeeException("Error while loading COFFEE JavaScript: " + this.coffeeJs.getAbsolutePath(), e);
                }
            }
            this.coffeeCompiler = newCoffeeCompiler;
        }
        return this.coffeeCompiler;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public int getWatchInterval() {
        return this.watchInterval;
    }

    public void setWatchInterval(int watchInterval) {
        this.watchInterval = watchInterval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public File getCoffeeJs() {
        return this.coffeeJs;
    }

    public void setCoffeeJs(File coffeeJs) {
        this.coffeeJs = coffeeJs;
    }

    public String getNodeExecutable() {
        return this.nodeExecutable;
    }

    public void setNodeExecutable(String nodeExecutable) {
        this.nodeExecutable = nodeExecutable;
    }

    public String getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public void setOutputFileFormat(String outputFileFormat) {
        this.outputFileFormat = outputFileFormat;
    }

    public void setArgs(String ... args) {
        this.args = args;
    }
}

