/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.coffeescript;

import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeCompiler;
import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeException;
import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeExecuteListener;
import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeExecuteThread;
import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeScriptCompiler;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.IPlugin;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

public class CoffeeScriptPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int restartInterval = 10000;
    private CoffeeScriptCompiler coffeeScriptCompiler;

    public CoffeeScriptPlugin() {
        this.coffeeScriptCompiler = new CoffeeScriptCompiler();
        this.coffeeScriptCompiler.setBuildContext(ThreadBuildContext.getContext());
        this.coffeeScriptCompiler.setSourceDirectory(new File(PathKit.getWebRootPath() + "/coffeescript/"));
        this.coffeeScriptCompiler.setOutputDirectory(new File(PathKit.getWebRootPath() + "/javascript/"));
        this.coffeeScriptCompiler.setCoffeeJs(new File(PathKit.getRootClassPath() + "/lib/coffee-script-1.7.1.min.js"));
        this.coffeeScriptCompiler.setArgs("--bare");
        this.coffeeScriptCompiler.setWatch(true);
    }

    public CoffeeScriptPlugin(CoffeeScriptCompiler coffeeScriptCompiler) {
        this.coffeeScriptCompiler = coffeeScriptCompiler;
    }

    public CoffeeScriptPlugin(int restartInterval, CoffeeScriptCompiler coffeeScriptCompiler) {
        this.restartInterval = restartInterval;
        this.coffeeScriptCompiler = coffeeScriptCompiler;
    }

    public boolean start() {
        CoffeeExecuteThread run = new CoffeeExecuteThread(this.coffeeScriptCompiler, this.restartInterval);
        CoffeeExecuteListener listen = new CoffeeExecuteListener(run);
        run.addObserver(listen);
        new Thread(run).start();
        return true;
    }

    public boolean stop() {
        return false;
    }

    public static void main(String[] args) throws IOException, CoffeeException {
        CoffeeCompiler coffeeCompiler = new CoffeeCompiler();
        String js = coffeeCompiler.compile("alert '\u6d4b\u8bd5'");
        coffeeCompiler = new CoffeeCompiler();
        js = coffeeCompiler.compile(new File(PathKit.getWebRootPath() + "/src/main/webapp/javascript/app/main.coffee"));
        CoffeeScriptCompiler coffeeScriptCompiler = new CoffeeScriptCompiler();
        coffeeScriptCompiler.setBuildContext(ThreadBuildContext.getContext());
        coffeeScriptCompiler.setSourceDirectory(new File(PathKit.getWebRootPath() + "/src/main/webapp/javascript/"));
        coffeeScriptCompiler.setForce(true);
        coffeeScriptCompiler.setArgs("--bare");
        coffeeScriptCompiler.setWatch(true);
        coffeeScriptCompiler.execute();
    }
}

