/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.atmosphere.chat;

import cn.dreampie.common.plugin.atmosphere.chat.ChatProtocol;
import cn.dreampie.common.plugin.atmosphere.chat.JsonEncoder;
import cn.dreampie.common.plugin.atmosphere.chat.ProtocolDecoder;
import cn.dreampie.common.plugin.atmosphere.chat.UserDecoder;
import cn.dreampie.common.plugin.atmosphere.chat.UserMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.PathParam;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.MetaBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedService(path="/im/{room: [a-zA-Z][a-zA-Z_0-9]*}")
public class ChatRoom {
    private final Logger logger = LoggerFactory.getLogger(ChatRoom.class);
    private final ConcurrentHashMap<String, String> users = new ConcurrentHashMap();
    private static final String CHAT = "/im/";
    @PathParam(value="room")
    private String chatroomName;
    private BroadcasterFactory factory;
    private AtmosphereResourceFactory resourceFactory;

    @Ready(value=Ready.DELIVER_TO.ALL, encoders={JsonEncoder.class})
    public ChatProtocol onReady(AtmosphereResource r) {
        this.logger.info("Browser {} connected.", (Object)r.uuid());
        this.factory = r.getAtmosphereConfig().getBroadcasterFactory();
        this.resourceFactory = r.getAtmosphereConfig().resourcesFactory();
        return new ChatProtocol(this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
    }

    private static Collection<String> getRooms(Collection<Broadcaster> broadcasters) {
        ArrayList<String> result = new ArrayList<String>();
        for (Broadcaster broadcaster : broadcasters) {
            if ("/*".equals(broadcaster.getID())) continue;
            result.add(broadcaster.getID().split("/")[2]);
        }
        return result;
    }

    @Disconnect
    public void onDisconnect(AtmosphereResourceEvent event) {
        if (event.isCancelled()) {
            this.users.values().remove(event.getResource().uuid());
            this.logger.info("Browser {} unexpectedly disconnected", (Object)event.getResource().uuid());
        } else if (event.isClosedByClient()) {
            this.logger.info("Browser {} closed the connection", (Object)event.getResource().uuid());
        }
    }

    @Message(encoders={JsonEncoder.class}, decoders={ProtocolDecoder.class})
    public ChatProtocol onMessage(ChatProtocol message) throws IOException {
        if (!this.users.containsKey(message.getAuthor())) {
            this.users.put(message.getAuthor(), message.getUuid());
            return new ChatProtocol(message.getAuthor(), " entered room " + this.chatroomName, this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
        }
        if (message.getMessage().contains("disconnecting")) {
            this.users.remove(message.getAuthor());
            return new ChatProtocol(message.getAuthor(), " disconnected from room " + this.chatroomName, this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
        }
        message.setUsers(this.users.keySet());
        this.logger.info("{} just send {}", (Object)message.getAuthor(), (Object)message.getMessage());
        return new ChatProtocol(message.getAuthor(), message.getMessage(), this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
    }

    @Message(decoders={UserDecoder.class})
    public void onPrivateMessage(UserMessage user) throws IOException {
        String userUUID = this.users.get(user.getAuthor());
        if (userUUID != null) {
            AtmosphereResource r = this.resourceFactory.find(userUUID);
            if (r != null) {
                ChatProtocol m = new ChatProtocol(user.getAuthor(), " sent you a private message: " + (user.getMessage().indexOf(":") > 0 ? user.getMessage().split(":")[1] : user.getMessage()), this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
                if (!user.getReceiver().equalsIgnoreCase("all")) {
                    this.factory.lookup((Object)(CHAT + this.chatroomName)).broadcast((Object)m, r);
                }
            }
        } else {
            ChatProtocol m = new ChatProtocol(user.getAuthor(), " sent a message to all chatroom: " + (user.getMessage().indexOf(":") > 0 ? user.getMessage().split(":")[1] : user.getMessage()), this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
            MetaBroadcaster.getDefault().broadcastTo("/*", (Object)m);
        }
    }
}

