/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.ehcache;

import cn.dreampie.common.ehcache.CacheNameRemove;
import cn.dreampie.common.util.ValidateUtils;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.plugin.ehcache.CacheKit;
import java.util.List;

public class CacheRemoveInterceptor
implements Interceptor {
    private static final String SLASH = "/";
    private static final String QMARK = "?";

    public void intercept(ActionInvocation ai) {
        ai.invoke();
        String removeCacheName = this.buildRemoveCacheName(ai);
        String[] removeCacheKeys = this.buildRemoveCacheKeys(ai);
        String controllerKey = ai.getControllerKey();
        if (!ValidateUtils.me().isNullOrEmpty(removeCacheName)) {
            String keyPrefix = null;
            if (!ValidateUtils.me().isNullOrEmpty(removeCacheKeys)) {
                for (String removeKey : removeCacheKeys) {
                    keyPrefix = controllerKey + SLASH + removeKey;
                    this.removeByCacheKey(removeCacheName, keyPrefix);
                }
            } else {
                keyPrefix = controllerKey;
                this.removeByCacheKey(removeCacheName, keyPrefix);
            }
        }
    }

    private void removeByCacheKey(String removeCacheName, String keyPrefix) {
        List keys = CacheKit.getKeys((String)removeCacheName);
        String keyStr = null;
        for (Object key : keys) {
            if (ValidateUtils.me().isNullOrEmpty(key) || !(keyStr = key.toString()).equals(keyPrefix) && !keyStr.startsWith(keyPrefix + SLASH) && !keyStr.startsWith(keyPrefix + QMARK)) continue;
            CacheKit.remove((String)removeCacheName, key);
        }
    }

    private String buildRemoveCacheName(ActionInvocation ai) {
        CacheNameRemove removeCacheName = ai.getMethod().getAnnotation(CacheNameRemove.class);
        if (removeCacheName != null) {
            return removeCacheName.name();
        }
        removeCacheName = ai.getController().getClass().getAnnotation(CacheNameRemove.class);
        if (removeCacheName != null) {
            return removeCacheName.name();
        }
        return null;
    }

    private String[] buildRemoveCacheKeys(ActionInvocation ai) {
        CacheNameRemove removeCacheName = ai.getMethod().getAnnotation(CacheNameRemove.class);
        if (removeCacheName != null) {
            return removeCacheName.keys();
        }
        removeCacheName = ai.getController().getClass().getAnnotation(CacheNameRemove.class);
        if (removeCacheName != null) {
            return removeCacheName.keys();
        }
        return null;
    }
}

