/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.config;

import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class JFinalConfig
extends com.jfinal.config.JFinalConfig {
    private Properties properties;

    public abstract void configConstant(Constants var1);

    public abstract void configRoute(Routes var1);

    public abstract void configPlugin(Plugins var1);

    public abstract void configInterceptor(Interceptors var1);

    public abstract void configHandler(Handlers var1);

    public void afterJFinalStart() {
    }

    public void beforeJFinalStop() {
    }

    public Properties loadPropertyFile(String file) {
        if (StrKit.isBlank((String)file)) {
            throw new IllegalArgumentException("Parameter of file can not be blank");
        }
        if (file.contains("..")) {
            throw new IllegalArgumentException("Parameter of file can not contains \"..\"");
        }
        FileInputStream inputStream = null;
        boolean startStuff = file.startsWith(File.separator);
        String fullFile = startStuff ? PathKit.getWebRootPath() + File.separator + "WEB-INF" + file : PathKit.getWebRootPath() + File.separator + "WEB-INF" + File.separator + file;
        File propFile = new File(fullFile);
        if (!propFile.exists() && !(propFile = new File(fullFile = startStuff ? PathKit.getRootClassPath() + file : PathKit.getRootClassPath() + File.separator + file)).exists()) {
            throw new IllegalArgumentException("Properties file not found: " + fullFile);
        }
        try {
            inputStream = new FileInputStream(propFile);
            Properties p = new Properties();
            p.load(inputStream);
            this.properties = p;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Properties file can not be loading: " + fullFile);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.properties == null) {
            throw new RuntimeException("Properties file loading failed: " + fullFile);
        }
        return this.properties;
    }

    public String getProperty(String key) {
        this.checkPropertyLoading();
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        this.checkPropertyLoading();
        return this.properties.getProperty(key, defaultValue);
    }

    public Integer getPropertyToInt(String key) {
        this.checkPropertyLoading();
        Integer resultInt = null;
        String resultStr = this.properties.getProperty(key);
        if (resultStr != null) {
            resultInt = Integer.parseInt(resultStr);
        }
        return resultInt;
    }

    public Integer getPropertyToInt(String key, Integer defaultValue) {
        Integer result = this.getPropertyToInt(key);
        return result != null ? result : defaultValue;
    }

    public Boolean getPropertyToBoolean(String key) {
        this.checkPropertyLoading();
        String resultStr = this.properties.getProperty(key);
        Boolean resultBool = null;
        if (resultStr != null) {
            if (resultStr.trim().equalsIgnoreCase("true")) {
                resultBool = true;
            } else if (resultStr.trim().equalsIgnoreCase("false")) {
                resultBool = false;
            }
        }
        return resultBool;
    }

    public Boolean getPropertyToBoolean(String key, boolean defaultValue) {
        Boolean result = this.getPropertyToBoolean(key);
        return result != null ? result : defaultValue;
    }

    private void checkPropertyLoading() {
        if (this.properties == null) {
            throw new RuntimeException("You must load properties file by invoking loadPropertyFile(String) method in configConstant(Constants) method before.");
        }
    }
}

