/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.DbSource;
import cn.dreampie.FlywayException;
import cn.dreampie.LogKit;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbConfig {
    private Log log = LogKit.getLog();
    private String config = "application.properties";
    private Properties properties;

    public DbConfig() {
        this.properties = this.readProperties(this.config);
    }

    public DbConfig(String config) {
        this.config = config;
        this.properties = this.readProperties(config);
    }

    public Properties readProperties(String filePath) {
        Properties properties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            properties.load(in);
        }
        catch (Exception e) {
            throw new FlywayException(e.getMessage());
        }
        return properties;
    }

    public List<String> getAllDbNames() {
        HashSet dbNames = Sets.newHashSet();
        Enumeration<Object> enums = this.properties.keys();
        String key = null;
        String dbName = null;
        while (enums.hasMoreElements()) {
            key = enums.nextElement() + "";
            if (!key.startsWith("db.")) continue;
            dbName = key.split("\\.")[1];
            dbNames.add(dbName);
        }
        return new ArrayList<String>(dbNames);
    }

    public Map<String, DbSource> getAllDbSources() {
        HashMap dbSourceMap = Maps.newHashMap();
        List<String> dbNames = this.getAllDbNames();
        for (String dbName : dbNames) {
            dbSourceMap.put(dbName, new DbSource(this.properties.getProperty("db." + dbName + ".driver"), this.properties.getProperty("db." + dbName + ".url"), this.properties.getProperty("db." + dbName + ".user"), this.properties.getProperty("db." + dbName + ".password")));
        }
        return dbSourceMap;
    }

    public boolean initOnMigrate(String dbName) {
        return this.properties.getProperty("flyway." + dbName + ".migration.initOnMigrate", "false").equals("true");
    }

    public boolean migrateAuto(String dbName) {
        return this.properties.getProperty("flyway." + dbName + ".migration.auto", "false").equals("true");
    }

    public boolean isClean(String dbName) {
        return this.properties.getProperty("flyway." + dbName + ".valid.clean", "false").equals("true");
    }

    public boolean isDev() {
        return this.properties.getProperty("flyway.devMode", "false").equals("true");
    }
}

