/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.AbstractCoffeeScript;
import cn.dreampie.CoffeeCompiler;
import cn.dreampie.CoffeeException;
import cn.dreampie.LogKit;
import cn.dreampie.resource.CoffeeSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;

public class CoffeeScriptCompiler
extends AbstractCoffeeScript {
    private Log log = LogKit.getLog();
    private CoffeeCompiler coffeeCompiler;
    protected File outputDirectory;
    private boolean compress;
    protected boolean watch = false;
    private int watchInterval = 1000;
    private String encoding;
    private boolean force;
    private File coffeeJs;
    private String outputFileFormat;
    private static final String FILE_NAME_FORMAT_PARAMETER_REGEX = "\\{fileName\\}";
    private String[] args;
    private long lastErrorModified = 0L;
    private boolean followDelete = false;
    private static final WatchEvent.Kind<?>[] watchEvents = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};

    public void execute() {
        this.log.info((CharSequence)("sourceDirectory = " + this.sourceDirectory));
        this.log.info((CharSequence)("outputDirectory = " + this.outputDirectory));
        this.log.debug((CharSequence)("includes = " + Arrays.toString(this.includes)));
        this.log.debug((CharSequence)("excludes = " + Arrays.toString(this.excludes)));
        this.log.debug((CharSequence)("force = " + this.force));
        this.log.debug((CharSequence)("coffeeJs = " + this.coffeeJs));
        this.log.debug((CharSequence)("skip = " + this.skip));
        if (!this.skip) {
            Object[] files = this.getIncludedFiles();
            if (files == null || files.length < 1) {
                this.log.info((CharSequence)"Nothing to compile - no coffee sources found");
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("included files = " + Arrays.toString(files)));
                }
                Object coffeeCompiler = this.initCoffeeCompiler();
                this.compileIfChanged((String[])files, coffeeCompiler);
                if (this.watch) {
                    this.log.info((CharSequence)("Watching " + this.sourceDirectory));
                    if (this.force) {
                        this.force = false;
                        this.log.info((CharSequence)"Disabled the 'force' flag in watch mode.");
                    }
                    this.startWatch((String[])files, coffeeCompiler);
                }
            }
        } else {
            this.log.info((CharSequence)"Skipping plugin execution per configuration");
        }
    }

    private void compileIfChanged(String[] files, Object coffeeCompiler) {
        for (String file : files) {
            this.compileIfChanged(coffeeCompiler, file);
        }
    }

    private void compileIfChanged(Object coffeeCompiler, String file) {
        File input = new File(this.sourceDirectory, file);
        this.buildContext.removeMessages(input);
        if (this.outputFileFormat != null) {
            file = this.outputFileFormat.replaceAll(FILE_NAME_FORMAT_PARAMETER_REGEX, file.replace(".coffee", ""));
        }
        String outFile = null;
        outFile = this.isCompress() ? file.replace(".coffee", ".min.js") : file.replace(".coffee", ".js");
        File output = new File(this.outputDirectory, outFile);
        if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
            this.log.error((CharSequence)("Cannot create output directory " + output.getParentFile()));
            return;
        }
        try {
            CoffeeSource coffeeSource = new CoffeeSource(input);
            long coffeeLastModified = coffeeSource.getLastModified();
            if (!output.exists() || (this.force || output.lastModified() < coffeeLastModified) && this.lastErrorModified < coffeeLastModified) {
                this.lastErrorModified = coffeeLastModified;
                long compilationStarted = System.currentTimeMillis();
                this.log.info((CharSequence)("Compiling coffee source: " + file));
                if (coffeeCompiler instanceof CoffeeCompiler) {
                    ((CoffeeCompiler)coffeeCompiler).compile(coffeeSource, output, this.force);
                }
                this.buildContext.refresh(output);
                this.log.info((CharSequence)("Finished compilation to " + this.outputDirectory + " in " + (System.currentTimeMillis() - compilationStarted) + " ms"));
            } else if (!this.watch) {
                this.log.info((CharSequence)("Bypassing coffee source: " + file + " (not modified)"));
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Error while compiling coffee source: " + file));
        }
        catch (CoffeeException e) {
            this.log.error((CharSequence)("Error while compiling coffee source: " + file));
        }
    }

    private Object initCoffeeCompiler() throws CoffeeException {
        if (this.coffeeCompiler == null) {
            CoffeeCompiler newCoffeeCompiler = new CoffeeCompiler();
            newCoffeeCompiler.setCompress(this.compress);
            newCoffeeCompiler.setEncoding(this.encoding);
            newCoffeeCompiler.setOptionArgs(this.args);
            if (this.coffeeJs != null) {
                try {
                    newCoffeeCompiler.setCoffeeJs(this.coffeeJs.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new CoffeeException("Error while loading coffeescript: " + this.coffeeJs.getAbsolutePath(), (Throwable)e);
                }
            }
            this.coffeeCompiler = newCoffeeCompiler;
        }
        return this.coffeeCompiler;
    }

    private void startWatch(String[] files, Object compiler) {
        Path sourcePath = this.sourceDirectory.toPath();
        Path outPath = this.outputDirectory.toPath();
        WatchService watchService = null;
        try {
            watchService = this.initWatch(sourcePath);
        }
        catch (IOException e) {
            throw new CoffeeException("Error watch sourceDirectory: " + this.sourceDirectory.getAbsolutePath(), (Throwable)e);
        }
        boolean changed = true;
        while (true) {
            if (changed) {
                this.log.info((CharSequence)"Waiting for changes...");
                changed = false;
            }
            WatchKey watchKey = null;
            try {
                watchKey = watchService.take();
            }
            catch (InterruptedException e) {
                this.log.error((CharSequence)"Error get watch key", (Throwable)e);
            }
            Path dir = (Path)watchKey.watchable();
            for (WatchEvent<?> event : watchKey.pollEvents()) {
                Path file = dir.resolve((Path)event.context());
                this.log.debug((CharSequence)String.format("watched %s - %s", event.kind().name(), file));
                if (Files.isDirectory(file, new LinkOption[0])) {
                    if (!event.kind().name().equals(StandardWatchEventKinds.ENTRY_CREATE.name())) continue;
                    try {
                        file.register(watchService, watchEvents);
                    }
                    catch (IOException e) {
                        this.log.error((CharSequence)"Error register new folder", (Throwable)e);
                    }
                    this.log.debug((CharSequence)String.format("watch %s", file));
                    continue;
                }
                String fileName = sourcePath.relativize(file).toString();
                String outName = "";
                for (String name : files) {
                    if (name == null || !name.equals(fileName)) continue;
                    outName = this.isCompress() ? fileName.replace(".coffee", ".min.js") : fileName.replace(".coffee", ".js");
                    if (Files.exists(sourcePath.resolve(fileName), new LinkOption[0]) && Files.notExists(outPath.resolve(outName), new LinkOption[0])) {
                        this.compileIfChanged(compiler, fileName);
                    }
                    if (event.kind().name().equals(StandardWatchEventKinds.ENTRY_DELETE.name())) {
                        if (!this.followDelete) continue;
                        try {
                            if (!Files.deleteIfExists(outPath.resolve(outName))) continue;
                            this.log.info((CharSequence)String.format("deleted %s with %s", outName, name));
                            changed = true;
                        }
                        catch (IOException e) {
                            this.log.error((CharSequence)("Error delete file:" + outName), (Throwable)e);
                        }
                        continue;
                    }
                    if (!event.kind().name().equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) && !event.kind().name().equals(StandardWatchEventKinds.ENTRY_CREATE.name())) continue;
                    this.compileIfChanged(compiler, fileName);
                    changed = true;
                }
            }
            watchKey.reset();
        }
    }

    private WatchService initWatch(Path sourceDirectory) throws IOException {
        final WatchService watchService = sourceDirectory.getFileSystem().newWatchService();
        Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                dir.register(watchService, watchEvents);
                CoffeeScriptCompiler.this.log.debug((CharSequence)String.format("watch %s", dir));
                return FileVisitResult.CONTINUE;
            }
        });
        return watchService;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public int getWatchInterval() {
        return this.watchInterval;
    }

    public void setWatchInterval(int watchInterval) {
        this.watchInterval = watchInterval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public File getCoffeeJs() {
        return this.coffeeJs;
    }

    public void setCoffeeJs(File coffeeJs) {
        this.coffeeJs = coffeeJs;
    }

    public String getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public void setOutputFileFormat(String outputFileFormat) {
        this.outputFileFormat = outputFileFormat;
    }

    public void setArgs(String ... args) {
        this.args = args;
    }

    public long getLastErrorModified() {
        return this.lastErrorModified;
    }

    public void setLastErrorModified(long lastErrorModified) {
        this.lastErrorModified = lastErrorModified;
    }

    public boolean isFollowDelete() {
        return this.followDelete;
    }

    public void setFollowDelete(boolean followDelete) {
        this.followDelete = followDelete;
    }
}

