/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.CoffeeExecuteListener;
import cn.dreampie.CoffeeExecuteThread;
import cn.dreampie.CoffeeScriptCompiler;
import cn.dreampie.LogKit;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="compile", threadSafe=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class CoffeeScriptMojo
extends AbstractMojo {
    private Log log = this.getLog();
    @Component
    protected BuildContext buildContext;
    @Parameter(defaultValue="${project.basedir}/src/main/coffeescript")
    protected File sourceDirectory;
    @Parameter
    protected String[] includes = new String[]{"**/*.coffee"};
    @Parameter
    protected String[] excludes = new String[0];
    @Parameter(defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${project.build.directory}/javascript", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean compress;
    @Parameter(defaultValue="false")
    protected boolean watch;
    @Parameter(defaultValue="1000")
    private int watchInterval;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="false")
    private boolean force;
    @Parameter
    private File coffeeJs;
    @Parameter
    private String nodeExecutable;
    @Parameter
    private String outputFileFormat;
    @Parameter
    private String[] args;
    @Parameter(defaultValue="1000")
    private int restartInterval;
    private CoffeeScriptCompiler coffeeScriptCompiler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LogKit.setLog(this.log);
        this.initCompiler();
        this.start();
    }

    private void initCompiler() {
        this.coffeeScriptCompiler = new CoffeeScriptCompiler();
        this.coffeeScriptCompiler.setBuildContext(this.buildContext);
        this.coffeeScriptCompiler.setIncludes(this.includes);
        this.coffeeScriptCompiler.setExcludes(this.excludes);
        this.coffeeScriptCompiler.setCoffeeJs(this.coffeeJs);
        this.coffeeScriptCompiler.setSkip(this.skip);
        this.coffeeScriptCompiler.setSourceDirectory(this.sourceDirectory);
        this.coffeeScriptCompiler.setOutputDirectory(this.outputDirectory);
        this.coffeeScriptCompiler.setForce(this.force);
        this.coffeeScriptCompiler.setEncoding(this.encoding);
        this.coffeeScriptCompiler.setCompress(this.compress);
        this.coffeeScriptCompiler.setArgs(this.args);
        this.coffeeScriptCompiler.setWatch(this.watch);
        this.coffeeScriptCompiler.setWatchInterval(this.watchInterval);
        this.coffeeScriptCompiler.setNodeExecutable(this.nodeExecutable);
        this.coffeeScriptCompiler.setOutputFileFormat(this.outputFileFormat);
    }

    private void start() {
        if (this.watch) {
            CoffeeExecuteThread thread = new CoffeeExecuteThread(this.coffeeScriptCompiler, this.restartInterval);
            CoffeeExecuteListener listen = new CoffeeExecuteListener(thread);
            thread.addObserver(listen);
            new Thread(thread).start();
        } else {
            this.coffeeScriptCompiler.execute();
        }
    }
}

