/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.AbstractCoffeeScript;
import cn.dreampie.CoffeeCompiler;
import cn.dreampie.CoffeeException;
import cn.dreampie.CoffeeSource;
import cn.dreampie.LogKit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class CoffeeScriptCompiler
extends AbstractCoffeeScript {
    private Log log = LogKit.getLog();
    private CoffeeCompiler coffeeCompiler;
    protected File outputDirectory;
    private boolean compress;
    protected boolean watch = false;
    private int watchInterval = 1000;
    private String encoding;
    private boolean force;
    private File coffeeJs;
    private String nodeExecutable;
    private String outputFileFormat;
    private static final String FILE_NAME_FORMAT_PARAMETER_REGEX = "\\{fileName\\}";
    private String[] args;
    private long lastErrorModified = 0L;

    public void execute() throws CoffeeException {
        this.log.info((CharSequence)("sourceDirectory = " + this.sourceDirectory));
        this.log.info((CharSequence)("outputDirectory = " + this.outputDirectory));
        this.log.debug((CharSequence)("includes = " + Arrays.toString(this.includes)));
        this.log.debug((CharSequence)("excludes = " + Arrays.toString(this.excludes)));
        this.log.debug((CharSequence)("force = " + this.force));
        this.log.debug((CharSequence)("coffeeJs = " + this.coffeeJs));
        this.log.debug((CharSequence)("skip = " + this.skip));
        if (!this.skip) {
            if (this.watch) {
                this.log.info((CharSequence)("Watching " + this.sourceDirectory));
                if (this.force) {
                    this.force = false;
                    this.log.info((CharSequence)"Disabled the 'force' flag in watch mode.");
                }
                Thread.currentThread().setPriority(1);
                while (this.watch && !Thread.currentThread().isInterrupted()) {
                    this.executeInternal();
                    try {
                        Thread.sleep(this.watchInterval);
                    }
                    catch (InterruptedException e) {
                        this.log.error((CharSequence)"interrupted");
                    }
                }
            } else {
                this.executeInternal();
            }
        } else {
            this.log.info((CharSequence)"Skipping plugin execution per configuration");
        }
    }

    private void executeInternal() throws CoffeeException {
        Object[] files = this.getIncludedFiles();
        if (files == null || files.length < 1) {
            this.log.info((CharSequence)"Nothing to compile - no coffee sources found");
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("included files = " + Arrays.toString(files)));
            }
            Object coffeeCompiler = this.initCoffeeCompiler();
            this.compileIfChanged((String[])files, coffeeCompiler);
        }
    }

    private void compileIfChanged(String[] files, Object coffeeCompiler) throws CoffeeException {
        for (String file : files) {
            File output;
            File input = new File(this.sourceDirectory, file);
            this.buildContext.removeMessages(input);
            if (this.outputFileFormat != null) {
                file = this.outputFileFormat.replaceAll(FILE_NAME_FORMAT_PARAMETER_REGEX, file.replace(".coffee", ""));
            }
            if (!(output = new File(this.outputDirectory, file.replace(".coffee", ".js"))).getParentFile().exists() && !output.getParentFile().mkdirs()) {
                throw new CoffeeException("Cannot create output directory " + output.getParentFile());
            }
            try {
                CoffeeSource coffeeSource = new CoffeeSource(input);
                long coffeeLastModified = coffeeSource.getLastModified();
                if (!output.exists() || (this.force || output.lastModified() < coffeeLastModified) && this.lastErrorModified < coffeeLastModified) {
                    this.lastErrorModified = coffeeLastModified;
                    long compilationStarted = System.currentTimeMillis();
                    this.log.info((CharSequence)("Compiling coffee source: " + file));
                    if (coffeeCompiler instanceof CoffeeCompiler) {
                        ((CoffeeCompiler)coffeeCompiler).compile(coffeeSource, output, this.force);
                    }
                    this.buildContext.refresh(output);
                    this.log.info((CharSequence)("Finished compilation to " + this.outputDirectory + " in " + (System.currentTimeMillis() - compilationStarted) + " ms"));
                    continue;
                }
                if (this.watch) continue;
                this.log.info((CharSequence)("Bypassing coffee source: " + file + " (not modified)"));
            }
            catch (IOException e) {
                throw new CoffeeException("Error while compiling coffee source: " + file, (Throwable)e);
            }
            catch (CoffeeException e) {
                String message = e.getMessage();
                if (StringUtils.isEmpty((String)message)) {
                    message = "Error compiling coffee source";
                }
                throw new CoffeeException("Error while compiling coffee source: " + file, (Throwable)e);
            }
        }
    }

    private Object initCoffeeCompiler() throws CoffeeException {
        if (this.coffeeCompiler == null) {
            CoffeeCompiler newCoffeeCompiler = new CoffeeCompiler();
            newCoffeeCompiler.setCompress(this.compress);
            newCoffeeCompiler.setEncoding(this.encoding);
            newCoffeeCompiler.setOptionArgs(this.args);
            if (this.coffeeJs != null) {
                try {
                    newCoffeeCompiler.setCoffeeJs(this.coffeeJs.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new CoffeeException("Error while loading coffeescript: " + this.coffeeJs.getAbsolutePath(), (Throwable)e);
                }
            }
            this.coffeeCompiler = newCoffeeCompiler;
        }
        return this.coffeeCompiler;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public int getWatchInterval() {
        return this.watchInterval;
    }

    public void setWatchInterval(int watchInterval) {
        this.watchInterval = watchInterval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public File getCoffeeJs() {
        return this.coffeeJs;
    }

    public void setCoffeeJs(File coffeeJs) {
        this.coffeeJs = coffeeJs;
    }

    public String getNodeExecutable() {
        return this.nodeExecutable;
    }

    public void setNodeExecutable(String nodeExecutable) {
        this.nodeExecutable = nodeExecutable;
    }

    public String getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public void setOutputFileFormat(String outputFileFormat) {
        this.outputFileFormat = outputFileFormat;
    }

    public void setArgs(String ... args) {
        this.args = args;
    }

    public long getLastErrorModified() {
        return this.lastErrorModified;
    }

    public void setLastErrorModified(long lastErrorModified) {
        this.lastErrorModified = lastErrorModified;
    }
}

