/*
 * Decompiled with CFR 0.152.
 */
package cn.dreamfame.core.secure.handler;

import cn.dreamfame.core.tool.api.ApiResult;
import cn.dreamfame.core.tool.utils.JsonUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.ObjectUtils;

public class LoginTargetAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(LoginTargetAuthenticationEntryPoint.class);
    private final String deviceActivateUri;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public LoginTargetAuthenticationEntryPoint(String loginFormUrl, String deviceActivateUri) {
        super(loginFormUrl);
        this.deviceActivateUri = deviceActivateUri;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String deviceVerificationUri = "/oauth2/device_verification";
        if (request.getRequestURI().equals(deviceVerificationUri) && request.getMethod().equals(HttpMethod.POST.name()) && UrlUtils.isAbsoluteUrl((String)this.deviceActivateUri)) {
            ApiResult success = ApiResult.fail((int)HttpStatus.UNAUTHORIZED.value(), (String)"\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u8bbe\u5907\u63d0\u4f9b\u7684\u9a8c\u8bc1\u5730\u5740");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentType("application/json");
            response.getWriter().write(JsonUtil.toJson((Object)success));
            response.getWriter().flush();
            return;
        }
        String loginForm = this.determineUrlToUseForThisRequest(request, response, authException);
        if (!UrlUtils.isAbsoluteUrl((String)loginForm)) {
            super.commence(request, response, authException);
            return;
        }
        StringBuffer requestUrl = request.getRequestURL();
        if (!ObjectUtils.isEmpty((Object)request.getQueryString())) {
            requestUrl.append("?").append(request.getQueryString());
        }
        String targetParameter = URLEncoder.encode(requestUrl.toString(), StandardCharsets.UTF_8);
        String targetUrl = loginForm + "?target=" + targetParameter + "&nonceId=" + request.getSession(Boolean.FALSE.booleanValue()).getId();
        log.debug("\u91cd\u5b9a\u5411\u81f3\u524d\u540e\u7aef\u5206\u79bb\u7684\u767b\u5f55\u9875\u9762\uff1a{}", (Object)targetUrl);
        this.redirectStrategy.sendRedirect(request, response, loginForm);
    }
}

