package cn.dreamfame.core.mp.support;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

import javax.sql.DataSource;
import java.util.Map;

/**
 * @author dreamfame
 * @date 2024/1/25 09:43
 * TODO
 */

@Slf4j
public class DynamicDataSource extends AbstractRoutingDataSource {

    private Map<Object, Object> dynamicTargetDataSources;

    public DynamicDataSource() {
    }

    /**
     * 决定使用哪个数据源之前需要把多个数据源的信息以及默认数据源信息配置好
     *
     * @param defaultTargetDataSource 默认数据源
     * @param targetDataSources       目标数据源
     */
    public DynamicDataSource(DataSource defaultTargetDataSource, Map<Object, Object> targetDataSources) {
        setDefaultTargetDataSource(defaultTargetDataSource);
        setTargetDataSources(targetDataSources);
        this.dynamicTargetDataSources = targetDataSources;
        super.afterPropertiesSet();
    }

    @Override
    protected DataSource determineTargetDataSource() {
        return super.determineTargetDataSource();
    }

    /**
     * 设置数据源
     * @param dataSources Map<Object, Object>
     */
    @Override
    public void setTargetDataSources(Map<Object, Object> dataSources) {

        super.setTargetDataSources(dataSources);

        this.dynamicTargetDataSources = dataSources;
    }

    /**
     * 设置默认数据源
     * @param defaultDataSource Object
     */
    @Override
    public void setDefaultTargetDataSource(Object defaultDataSource) {
        super.setDefaultTargetDataSource(defaultDataSource);
    }

    /**
     * 取得当前使用哪个数据源
     *
     * @return
     */
    @Override
    protected Object determineCurrentLookupKey() {
      return DbContextHolder.getDbType();
    }

    public void setDataSources(String dbName,String driverName,String url,String username,String password) {
        try {
            DataSource dataSource = DataSourceBuilder.create().driverClassName(driverName).url(url).username(username).password(password).build();
            // 测试连接
            dataSource.getConnection();

            this.dynamicTargetDataSources.put(dbName, dataSource);
            setTargetDataSources(this.dynamicTargetDataSources);
            super.afterPropertiesSet();
            log.info("数据源初始化成功------>" + dbName);
        } catch (Exception e) {
            throw new IllegalStateException("[" + dbName + "]" + "：数据源连接失败！");
        }
    }
}
