package cn.dreamfame.core.mp.support;

/**
 * @author dreamfame
 * @date 2024/1/25 09:43
 * TODO
 */
public class DbContextHolder {

    private static final ThreadLocal contextHolder = new ThreadLocal();

    /**
     * 设置数据源
     *
     * @param type
     */
    public static void setDbType(String type) {
        contextHolder.set(type);
    }

    /**
     * 取得当前数据源
     *
     * @return
     */
    public static String getDbType() {
        return (String) contextHolder.get();
    }

    /**
     * 清除上下文数据
     */
    public static void clearDbType() {
        contextHolder.remove();
    }


}
