package cn.dreamfame.core.mp.plugins;

import cn.dreamfame.core.mp.intercept.QueryInterceptor;
import cn.dreamfame.core.tool.utils.ObjectUtil;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

/**
 * @author dreamfame
 * @date 2023/11/24 10:49
 * 查询拦截器执行器
 */
@SuppressWarnings({"rawtypes"})
public class QueryInterceptorExecutor {

    /**
     * 执行查询拦截器
     */
    static void exec(QueryInterceptor[] interceptors, Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws Throwable {
        if (ObjectUtil.isEmpty(interceptors)) {
            return;
        }
        for (QueryInterceptor interceptor : interceptors) {
            interceptor.intercept(executor, ms, parameter, rowBounds, resultHandler, boundSql);
        }
    }

}
