package cn.dreamfame.core.mp.develop;

import cn.dreamfame.core.tool.utils.StrUtil;
import cn.dreamfame.core.tool.utils.ToolUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.StringPool;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.OracleTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.PostgreSqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.SqlServerTypeConvert;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

import java.io.IOException;
import java.util.*;

/**
 * @author dreamfame
 * @date 2023/12/11 16:45
 * TODO
 */
@Data
@Slf4j
public class DreamCodeGenerator {
    /**
     * 代码模块名称
     */
    private String codeName;
    /**
     * 代码所在服务名
     */
    private String serviceName = "df-service";
    /**
     * 代码生成的包名
     */
    private String packageName = "com.ll.service.devOps";
    /**
     * 实体类代码生成的包名
     */
    private String entityPackageName = "com.ll.api.service.devOps";
    /**
     * 接口地址
     */
    private String apiDir;

    /**
     * 代码后端生成的地址
     */
    private String packageDir;
    /**
     * 代码前端生成的地址
     */
    private String packageWebDir;
    /**
     * 需要去掉的表前缀
     */
    private String[] tablePrefix = {"devOps_"};
    /**
     * 需要生成的表名(两者只能取其一)
     */
    private String[] includeTables = {"df_demo"};
    /**
     * 需要排除的表名(两者只能取其一)
     */
    private String[] excludeTables = {};
    /**
     * 是否包含基础业务字段
     */
    private Boolean hasSuperEntity = Boolean.FALSE;
    /**
     * 是否包含包装器
     */
    private Boolean hasWrapper = Boolean.FALSE;
    /**
     * 基础业务字段
     */
    private String[] superEntityColumns = {"create_time", "create_by", "update_time", "update_by", "status", "is_deleted"};
    /**
     * 是否启用swagger
     */
    private Boolean isSwagger2 = Boolean.TRUE;
    /**
     * 数据库驱动名
     */
    private String driverName;
    /**
     * 数据库链接地址
     */
    private String url;
    /**
     * 数据库用户名
     */
    private String username;
    /**
     * 数据库密码
     */
    private String password;

    public void run() {
        Properties props = getProperties();
        AutoGenerator mpg = new AutoGenerator();
        GlobalConfig gc = new GlobalConfig();
        String outputDir = getOutputDir();
        String author = props.getProperty("author");
        gc.setOutputDir(outputDir);
        gc.setAuthor(author);
        gc.setFileOverride(true);
        gc.setOpen(false);
        gc.setActiveRecord(false);
        gc.setEnableCache(false);
        gc.setBaseResultMap(true);
        gc.setBaseColumnList(true);
        gc.setMapperName("%sMapper");
        gc.setXmlName("%sMapper");
        gc.setServiceName("I%sService");
        gc.setServiceImplName("%sServiceImpl");
        gc.setControllerName("%sController");
        gc.setSwagger2(isSwagger2);
        mpg.setGlobalConfig(gc);
        DataSourceConfig dsc = new DataSourceConfig();
        String driverName = ToolUtil.toStr(this.driverName, props.getProperty("spring.datasource.driver-class-name"));
        if (StrUtil.containsAny(driverName, DbType.MYSQL.getDb())) {
            dsc.setDbType(DbType.MYSQL);
            dsc.setTypeConvert(new MySqlTypeConvert());
        } else if (StrUtil.containsAny(driverName, DbType.POSTGRE_SQL.getDb())) {
            dsc.setDbType(DbType.POSTGRE_SQL);
            dsc.setTypeConvert(new PostgreSqlTypeConvert());
        } else if (StrUtil.containsAny(driverName, DbType.SQL_SERVER.getDb())) {
            dsc.setDbType(DbType.SQL_SERVER);
            dsc.setTypeConvert(new SqlServerTypeConvert());
        } else {
            dsc.setDbType(DbType.ORACLE);
            dsc.setTypeConvert(new OracleTypeConvert());
        }
        dsc.setDriverName(driverName);
        dsc.setUrl(ToolUtil.toStr(this.url, props.getProperty("spring.datasource.url")));
        dsc.setUsername(ToolUtil.toStr(this.username, props.getProperty("spring.datasource.username")));
        dsc.setPassword(ToolUtil.toStr(this.password, props.getProperty("spring.datasource.password")));
        mpg.setDataSource(dsc);
        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        // strategy.setCapitalMode(true);// 全局大写命名
        // strategy.setDbColumnUnderline(true);//全局下划线命名
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setTablePrefix(tablePrefix);
        if (includeTables.length > 0) {
            strategy.setInclude(includeTables);
        }
        if (excludeTables.length > 0) {
            strategy.setExclude(excludeTables);
        }
        if (hasSuperEntity) {
            strategy.setSuperEntityClass("com.ll.core.mp.base.BaseEntity");
            strategy.setSuperEntityColumns(superEntityColumns);
            strategy.setSuperServiceClass("com.ll.core.mp.base.BaseService");
            strategy.setSuperServiceImplClass("com.ll.core.mp.base.BaseServiceImpl");
        } else {
            strategy.setSuperServiceClass("com.baomidou.mybatisplus.extension.service.IService");
            strategy.setSuperServiceImplClass("com.baomidou.mybatisplus.extension.service.impl.ServiceImpl");
        }
        // 自定义 controller 父类
        //strategy.setSuperControllerClass("com.ll.core.boot.ctrl.DreamController");
        strategy.setEntityBuilderModel(false);
        strategy.setEntityLombokModel(true);
        strategy.setControllerMappingHyphenStyle(true);
        mpg.setStrategy(strategy);
        // 包配置
        PackageConfig pc = new PackageConfig();
        // 控制台扫描
        pc.setModuleName(null);
        pc.setParent(packageName);
        pc.setController("controller");
        pc.setEntity("entity");
        pc.setXml("mapper");
        mpg.setPackageInfo(pc);
        mpg.setCfg(getInjectionConfig());
        mpg.execute();
    }

    private InjectionConfig getInjectionConfig() {
        String servicePackage = serviceName.split("-").length > 1 ? serviceName.split("-")[1] : serviceName;
        // 自定义配置
        Map<String, Object> map = new HashMap<>(16);
        InjectionConfig cfg = new InjectionConfig() {
            @Override
            public void initMap() {
                map.put("codeName", codeName);
                map.put("entityPackage",entityPackageName);
                map.put("serviceName", serviceName);
                map.put("servicePackage", servicePackage);
                map.put("servicePackageLowerCase", servicePackage.toLowerCase());
                map.put("hasWrapper", hasWrapper);
                map.put("apiDir",apiDir);
                this.setMap(map);
            }
        };
        List<FileOutConfig> focList = new ArrayList<>();
        focList.add(new FileOutConfig("/templates/entityVO.java.vm") {
            @Override
            public String outputFile(TableInfo tableInfo) {
                return getOutputDir() + "/" + packageName.replace(".", "/") + "/" + "vo" + "/" + tableInfo.getEntityName() + "VO" + StringPool.DOT_JAVA;
            }
        });
        focList.add(new FileOutConfig("/templates/entityDTO.java.vm") {
            @Override
            public String outputFile(TableInfo tableInfo) {
                return getOutputDir() + "/" + packageName.replace(".", "/") + "/" + "dto" + "/" + tableInfo.getEntityName() + "DTO" + StringPool.DOT_JAVA;
            }
        });
        if (hasWrapper) {
            focList.add(new FileOutConfig("/templates/wrapper.java.vm") {
                @Override
                public String outputFile(TableInfo tableInfo) {
                    return getOutputDir() + "/" + packageName.replace(".", "/") + "/" + "wrapper" + "/" + tableInfo.getEntityName() + "Wrapper" + StringPool.DOT_JAVA;
                }
            });
        }
        cfg.setFileOutConfigList(focList);
        return cfg;
    }

    /**
     * 获取配置文件
     *
     * @return 配置Props
     */
    private Properties getProperties() {
        // 读取配置文件
        Resource resource = new ClassPathResource("/templates/code.properties");
        Properties props = new Properties();
        try {
            props = PropertiesLoaderUtils.loadProperties(resource);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    /**
     * 生成到项目中
     *
     * @return outputDir
     */
    public String getOutputDir() {
        return packageDir;
    }


    public static void main(String[] args){
        DreamCodeGenerator generator = new DreamCodeGenerator();
        generator.setDriverName("com.mysql.cj.jdbc.Driver");
        generator.setUrl("jdbc:mysql://localhost:3306/oms?useSSL=false&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&transformedBitIsBoolean=true&tinyInt1isBit=false&serverTimezone=GMT%2B8");
        generator.setUsername("root");
        generator.setPassword("ycxy@2020");
        generator.setCodeName("oms");
        generator.setTablePrefix(new String[]{"oms"});
        generator.setPackageName("com.dream.framework.oms");
        generator.setEntityPackageName("com.dream.framework.api.application");
        generator.setServiceName("df-oms");
        generator.setPackageDir("D:/oms/code");
        generator.setHasWrapper(true);
        Scanner sc = new Scanner(System.in);
        System.out.println("输入数据库表名称:");
        String tableName = sc.nextLine();
        generator.setIncludeTables(new String[]{tableName});
        System.out.println("输入是否包含基础业务（true/false）:");
        boolean hasSuperEntity = sc.nextBoolean();
        generator.setHasSuperEntity(hasSuperEntity);
        generator.run();
    }

}
