package cn.dreamfame.core.mp.base;

import cn.dreamfame.core.secure.util.SecureUtil;
import cn.dreamfame.core.tool.constants.DreamConstant;
import cn.dreamfame.core.tool.utils.DateUtil;
import cn.dreamfame.core.tool.utils.StrUtil;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.validation.constraints.NotEmpty;
import org.springframework.validation.annotation.Validated;

import java.util.Date;
import java.util.List;

/**
 * @author dreamfame
 * @date 2023/11/21 14:25
 * 基础服务实现
 */
@Validated
public class BaseServiceImpl<M extends BaseMapper<T>, T extends BaseEntity> extends ServiceImpl<M, T> implements BaseService<T> {

    @Override
    public boolean save(T entity) {
        try {
          String userId = SecureUtil.getUserId();
          if (StrUtil.isNotBlank(userId)) {
            entity.setCreateBy(userId);
            entity.setUpdateBy(userId);
          }
        }catch(Exception e){
          entity.setCreateBy(null);
          entity.setUpdateBy(null);
        }
        Date now = DateUtil.now();
        entity.setCreateTime(now);
        entity.setUpdateTime(now);
        if (entity.getStatus() == null) {
            entity.setStatus(DreamConstant.DB_STATUS_NORMAL);
        }
        entity.setIsDeleted(DreamConstant.DB_NOT_DELETED);
        return super.save(entity);
    }

    @Override
    public boolean updateById(T entity) {
        try {
          String userId = SecureUtil.getUserId();
          if (StrUtil.isNotBlank(userId)) {
            entity.setUpdateBy(userId);
          }
        }catch (Exception e){
          entity.setUpdateBy(null);
        }
        entity.setUpdateTime(DateUtil.now());
        return super.updateById(entity);
    }

    @Override
    public boolean deleteLogic(@NotEmpty List<String> ids) {
        return super.removeByIds(ids);
    }
}
