package cn.dreamfame.core.mp.aop;

import cn.dreamfame.core.mp.support.DbContextHolder;
import cn.dreamfame.core.tool.constants.DreamConstant;
import cn.dreamfame.core.mp.anno.DataSourceSwitch;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.Objects;
/**
 * @author dreamfame
 * @date 2024/1/25 09:46
 * TODO
 */
@Component
@Aspect
@Order(-100)
@Slf4j
public class DataSourceSwitchAspect {

    @Pointcut("execution(* cn.dreamfame.*.service..*.*(..))")
    private void dbAspect() {

    }

    @Before("dbAspect()")
    public void db(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        DataSourceSwitch dataSourceSwitch = methodSignature.getMethod().getAnnotation(DataSourceSwitch.class);
        if (Objects.isNull(dataSourceSwitch) || Objects.isNull(dataSourceSwitch.value())) {
            DbContextHolder.setDbType(DreamConstant.DB_MASTER);
        } else {
            DbContextHolder.setDbType(dataSourceSwitch.value());
        }
    }

}
