package cn.dreamfame.core.mp.support;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.dreamfame.core.tool.constants.TokenConstant;
import cn.dreamfame.core.tool.support.Kv;
import cn.dreamfame.core.tool.utils.BeanUtil;
import cn.dreamfame.core.tool.utils.StrUtil;
import cn.dreamfame.core.tool.utils.ToolUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @author dreamfame
 * @date 2023/12/11 11:21
 * 条件工具
 */
public class Condition {

    /**
     * 转化成mybatis plus中的Page
     *
     * @param query 查询条件
     * @return IPage
     */
    public static <T> IPage<T> getPage(Query query) {
        Page<T> page = new Page<>(ToolUtil.toInt(query.getCurrent(), 1), ToolUtil.toInt(query.getSize(), 10));
        String[] ascArr = ToolUtil.toStrArray(query.getAscs());
        for (String asc : ascArr) {
            page.addOrder(OrderItem.asc(StrUtil.cleanIdentifier(asc)));
        }
        String[] descArr = ToolUtil.toStrArray(query.getDescs());
        for (String desc : descArr) {
            page.addOrder(OrderItem.desc(StrUtil.cleanIdentifier(desc)));
        }
        return page;
    }

  /**
   * 获取mybatis plus中的QueryWrapper
   * @param query
   * @return
   * @param <T>
   */
  public static <T> QueryWrapper<T> getQueryWrapper(Query<T> query) {
    QueryWrapper<T> qw = new QueryWrapper<>();
    qw.setEntity(query.getEntity());
    Map<String,Object> tempMap = BeanUtil.toMap(query);
    Map<String,Object> queryMap = new HashMap<>();
    queryMap.putAll(tempMap);
    Map<String,Object> excludeMap = BeanUtil.toMap(BeanUtil.newInstance(Query.class));
    excludeMap.forEach((k, v) -> queryMap.remove(k));
    SqlKeyword.buildCondition(queryMap, qw);
    return qw;
  }

    /**
     * 获取mybatis plus中的QueryWrapper
     *
     * @param entity 实体
     * @param <T>    类型
     * @return QueryWrapper
     */
    public static <T> QueryWrapper<T> getQueryWrapper(T entity) {
        return new QueryWrapper<>(entity);
    }

    /**
     * 获取mybatis plus中的QueryWrapper
     *
     * @param query 查询条件
     * @param clazz 实体类
     * @param <T>   类型
     * @return QueryWrapper
     */
    public static <T> QueryWrapper<T> getQueryWrapper(Map<String, Object> query, Class<T> clazz) {
        Kv exclude = Kv.init().set(TokenConstant.HEADER, TokenConstant.HEADER)
                .set("current", "current").set("size", "size").set("ascs", "ascs").set("descs", "descs");
        return getQueryWrapper(query, exclude, clazz);
    }

    /**
     * 获取mybatis plus中的QueryWrapper
     *
     * @param query   查询条件
     * @param exclude 排除的查询条件
     * @param clazz   实体类
     * @param <T>     类型
     * @return QueryWrapper
     */
    public static <T> QueryWrapper<T> getQueryWrapper(Map<String, Object> query, Map<String, Object> exclude, Class<T> clazz) {
        exclude.forEach((k, v) -> query.remove(k));
        QueryWrapper<T> qw = new QueryWrapper<>();
        qw.setEntity(BeanUtil.newInstance(clazz));
        SqlKeyword.buildCondition(query, qw);
        return qw;
    }
}
