package cn.dreamfame.core.mp.props;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author dreamfame
 * @date 2023/11/24 10:30
 * mp属性
 */
@Data
@ConfigurationProperties(prefix = "dream.mybatis-plus")
public class MybatisPlusProperties {

    /**
     * 分页最大数
     */
    private Long pageLimit = 500L;

    /**
     * 溢出总页数后是否进行处理
     */
    protected Boolean overflow = false;

}
