package cn.dreamfame.core.mp.base;

import cn.dreamfame.core.tool.constants.DatePattern;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author dreamfame
 * @date 2023/11/21 14:23
 * 实体基类
 */
@Data
public class BaseEntity implements Serializable {

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = DatePattern.PATTERN_DATETIME)
    @JsonFormat(pattern = DatePattern.PATTERN_DATETIME,timezone = "GMT+8")
    private Date createTime;

    /**
     * 更新人
     */
    private String updateBy;

    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = DatePattern.PATTERN_DATETIME)
    @JsonFormat(pattern = DatePattern.PATTERN_DATETIME,timezone = "GMT+8")
    private Date updateTime;

    /**
     * 状态[1:正常]
     */
    private Integer status;

    /**
     * 状态[0:未删除,1:删除]
     */
    @TableLogic
    private Integer isDeleted;

}
