package cn.dreamfame.core.launch.constant;

/**
 * @author dreamfame
 * @date 2023/9/27 下午4:21
 * 应用常量
 */
public interface AppConstant {

    /**
     * 应用版本
     */
    String APPLICATION_VERSION = "1.0.2";

    /**
     * 基础包
     */
    String BASE_PACKAGES = "com.ll";

    /**
     * 应用名前缀
     */
    String APPLICATION_NAME_PREFIX = "df-";

    String APPLICATION_LOG_NAME = APPLICATION_NAME_PREFIX + "log";

    /**
     * 网关模块名称
     */
    String APPLICATION_GATEWAY_NAME = APPLICATION_NAME_PREFIX + "gateway";

    /**
     * 开发环境
     */
    String DEV_CODE = "dev";
    /**
     * 生产环境
     */
    String PROD_CODE = "prod";
    /**
     * 测试环境
     */
    String TEST_CODE = "test";

    /**
     * 代码部署于 linux 上，工作默认为 mac 和 Windows
     */
    String OS_NAME_LINUX = "LINUX";


}
