package cn.dreamfame.core.launch.constant;

/**
 * @author dreamfame
 * @date 2023/9/27 下午4:23
 * nacos常量
 */
public interface NacosConstant {

    /**
     * nacos 地址
     */
    String NACOS_ADDR = "127.0.0.1:8848";

    /**
     * nacos 命名空间
     */
    String NACOS_NAMESPACE = "47bf8a14-bfd9-4286-bb8b-f84d356449ac";

    /**
     * nacos 用户名
     */
    String NACOS_USERNAME = "liuliu";

    /**
     * nacos 密码
     */
    String NACOS_PASSWORD = "liuliu";

    /**
     * nacos 配置前缀
     */
    String NACOS_CONFIG_PREFIX = "dream";

    /**
     * nacos 组配置后缀
     */
    String NACOS_GROUP_SUFFIX = "-group";

    /**
     * nacos 配置文件类型
     */
    String NACOS_CONFIG_FORMAT = "yaml";

    /**
     * nacos json配置文件类型
     */
    String NACOS_CONFIG_JSON_FORMAT = "json";

    /**
     * nacos 是否刷新
     */
    String NACOS_CONFIG_REFRESH = "true";

    /**
     * nacos 分组
     */
    String NACOS_CONFIG_GROUP = "df";

    /**
     * 构建服务对应的 dataId
     *
     * @param appName 服务名
     * @param profile 环境变量
     * @return dataId
     */
    static String dataId(String appName, String profile) {
        return dataId(appName, profile, NACOS_CONFIG_FORMAT);
    }

    /**
     * 构建服务对应的 dataId
     *
     * @param appName 服务名
     * @param profile 环境变量
     * @param format  文件类型
     * @return dataId
     */
    static String dataId(String appName, String profile, String format) {
        return appName + "-" + profile + "." + format;
    }

}
