package cn.donting.plugin.spring.boot.starter.utile;

import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import java.io.UnsupportedEncodingException;
import java.util.*;

/**
 *
 * @author donting
 *  2020-04-23 下午2:43
 */
public class SpringApplicationUtil {

    public static <T> List<T> orderSort(List<T> collection) {
        Collections.sort(collection, (o1, o2) -> {
            Order annotation1 = o1.getClass().getAnnotation(Order.class);
            int o1Order1 = Ordered.LOWEST_PRECEDENCE;
            if (annotation1 != null) {
                o1Order1 = annotation1.value();
            }
            Order annotation2 = o2.getClass().getAnnotation(Order.class);
            int o1Order2 = Ordered.LOWEST_PRECEDENCE;
            if (annotation2 != null) {
                o1Order2 = annotation2.value();
            }
            if (o1Order1 == o1Order2) {
                return 0;
            }
            if (o1Order1 < o1Order2) {
                return -1;
            }
            return 1;
        });
        return collection;
    }
}
