package cn.donting.plugin.spring.boot.starter.properties;

import cn.donting.plugin.spring.boot.starter.Plugin;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

import java.io.File;

/**
 * @author donting
 * 2020-04-17 上午11:03
 */
@Configuration
@ConfigurationProperties("donting.plugin")
@Data
public class PluginProperties {

    private static ApplicationContext applicationContext;

    public enum VisitEnum {

        HEADER("HEADER"), URL("URL"), QUERY("QUERY");
        public String value;

        VisitEnum(String value) {
            this.value = value;
        }

    }

    public PluginProperties(ApplicationContext applicationContext) {
        PluginProperties.applicationContext = applicationContext;
    }

    public static String[] visits() {
        PluginProperties bean = applicationContext.getBean(PluginProperties.class);
        String parentProperties = bean.getVisit();
        String[] split = parentProperties.split(separator);
        return split;
    }

    /**
     * 获取主程序中的插件的配置
     *
     * @return PluginProperties
     */
    public static PluginProperties getMainPlugProperties() {
        PluginProperties bean = applicationContext.getBean(PluginProperties.class);
        return bean;
    }


    /**
     * 配置分隔符
     */
    public final static String separator = ";";

    /**
     * 启动时是否加载插件目录下的插件
     */
    private Boolean autoLoad = Boolean.TRUE;

    /**
     * 自动注入插件访问controller
     *
     * @RequestMapping("/**")
     */
    private Boolean autoVisit = Boolean.TRUE;

    /**
     * 插件访问标识
     * url  /{pludId}/**
     * header
     * query
     */
    private String visit = "header;query;url";
    /**
     * visit 访问标识的key
     */
    private String visitLKey = "plugId";

    /**
     * 是否自动 注入控制插件的 Controller
     * 否：请使用 PluginManger
     */
    private Boolean autoController = Boolean.TRUE;
    /**
     * 插件路径，安装的插件会复制到该路径下
     */
    private String path = System.getProperty("user.dir") + File.separator + "plug";


    /**
     * 运行模式
     * run 运行模式
     * dev 插件开发模式
     */
    private String runMode = "run";

//    /**
//     * 资源加载方式
//     */
//    private ResourceModeEnum resourceMode=ResourceModeEnum.PLUGIN;


    @Deprecated
    public static enum ResourceModeEnum {
        /**
         * 插件优先
         */
        PLUGIN,
        /**
         * 主程序优先
         */
        MAIN,
        /**
         * 仅插件
         */
        ONLY_PLUGIN,

    }
}

