package cn.donting.plugin.spring.boot.starter.exception;

import lombok.Getter;

/**
 * @author donting
 * 插件的异常
 * 2020-04-17 下午3:29
 */
@Getter
public class PluginRuntimeException extends RuntimeException {

    private String zh_msg;


    public PluginRuntimeException(String message, String zh_msg) {
        super(message);
        this.zh_msg = zh_msg;
    }

    public PluginRuntimeException(String message, String zh_msg, Throwable cause) {
        super(message, cause);
        this.zh_msg = zh_msg;
    }

    public PluginRuntimeException(String message) {
        super(message);
    }

    public PluginRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

}
