package cn.donting.plugin.spring.boot.starter.dev;

import cn.donting.plugin.spring.boot.starter.AbsPluginLoader;
import cn.donting.plugin.spring.boot.starter.Plugin;
import cn.donting.plugin.spring.boot.starter.PluginWrapper;
import cn.donting.plugin.spring.boot.starter.dev.DevPluginClassLoader;
import cn.donting.plugin.spring.boot.starter.dev.DevPluginRun;
import cn.donting.plugin.spring.boot.starter.exception.PluginLoadException;
import cn.donting.plugin.spring.boot.starter.utile.ClassUtil;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

/**
 *
 * 插件开发的加载器
 * @author donting
 *  2020-05-13 下午4:32
 */
@Slf4j
public class DevPluginLoader extends AbsPluginLoader {

    @Getter
    private static PluginWrapper pluginDevWrapper;

    @Override
    public PluginWrapper load(File file) throws IOException, PluginLoadException {

        Class<?> plugDevClass = DevPluginRun.getPlugDevClass();
        DevPluginClassLoader devPluginClassLoader = DevPluginRun.getDevPluginClassLoader();
        Plugin plugin = plugDevClass.getAnnotation(Plugin.class);
        PluginWrapper pluginWrapper=new PluginWrapper(file.getPath(), devPluginClassLoader, plugin, plugDevClass);
        log.info("加载开发插件：name->"+plugin.name()+" id:{}",plugin.id());
        pluginDevWrapper=pluginWrapper;
        return pluginWrapper;
    }

    @Override
    public boolean isApplicable(File file) {
        return false;
    }


    private File[] getFiles(File file){
        return file.listFiles();
    }

}
