
package cn.donting.plugin.spring.boot.starter.dev;

import cn.donting.plugin.spring.boot.starter.PluginClassLoader;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.tomcat.util.buf.UEncoder;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

@Slf4j
public class DevPluginClassLoader extends PluginClassLoader {

    private static final String JAVA_PACKAGE_PREFIX = "java.";
    private static final String JAVAX_PACKAGE_PREFIX = "javax.";
    private static final String PLUGIN_PACKAGE_PREFIX = "cn.donting.plugin.spring.boot.starter.";

    @Getter
    private  final File classFile;
    public DevPluginClassLoader(URL urls, ClassLoader parent) {
        super(new URL[]{urls}, parent);

        try {
            classFile=new File(URLDecoder.decode(urls.getPath(),"Utf-8"));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(),e);
        }
    }

}
