package cn.donting.plugin.spring.boot.starter.contorller;

import cn.donting.plugin.spring.boot.starter.WebPluginManger;
import cn.donting.plugin.spring.boot.starter.RequestPlugId;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author donting
 * 2020-04-17 下午8:41
 */
@Slf4j
//@Configuration
@RestController
public class VisitController {


    @Autowired
    RequestPlugId requestPlugId;
    @Autowired
    WebPluginManger webPluginManger;


    @RequestMapping(path = "/plugin/visit")
    public void url(HttpServletRequest request, HttpServletResponse response) throws Exception {

        if(request instanceof PluginHttpRequestWrapper){
                request=((PluginHttpRequestWrapper) request).getHttpServletRequest();

        }else{
            log.warn("request is not PluginHttpRequestWrapper");
        }
        webPluginManger.doService(request, response);
    }



}
