package cn.donting.plugin.spring.boot.starter.contorller;

import lombok.extern.slf4j.Slf4j;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;

/**
 * @author donting
 */
@Slf4j
@WebFilter(filterName = "PluginFilter", urlPatterns = "/*")
public class PluginFilter implements Filter {
    public static final String[] urls=new String[]{
            "/plugin/"
    };

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("pluginFilter......");

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        String url = httpRequest.getRequestURI();
        if (url.startsWith("/plugin/")) {
            chain.doFilter(request,response);
        }else{
            PluginHttpRequestWrapper httpServletRequestWrapper=new PluginHttpRequestWrapper(httpRequest);

            request.getRequestDispatcher("/plugin/visit").forward(httpServletRequestWrapper,response);
        }
    }
}
