package cn.donting.plugin.spring.boot.starter.contorller;

import cn.donting.plugin.spring.boot.starter.PluginDbInfo;
import cn.donting.plugin.spring.boot.starter.PluginManger;
import cn.donting.plugin.spring.boot.starter.exception.PluginException;
import cn.donting.plugin.spring.boot.starter.PluginDb;
import cn.donting.plugin.spring.boot.starter.exception.PluginUpdateException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;

/**
 * @author donting
 * 2020-04-17 上午11:35
 */
@Slf4j
@RequestMapping("/plugin/")
@RestController
public class PluginController {


    @Autowired
    PluginManger pluginManger;

    @Autowired
    PluginDb plugDb;

    @PostMapping("upload")
    @ResponseBody
    public ResEntity install(MultipartFile file) throws IOException {
        byte[] bytes = file.getBytes();
        try {
            pluginManger.install(bytes);
        } catch (PluginException e) {
            log.warn(e.getMessage(), e);
            return ResEntity.fall(file.getOriginalFilename() + e.getZh_msg());
        }
        return ResEntity.success();
    }

    @GetMapping("uninstall/{id}")
    @ResponseBody
    public ResEntity uninstall(@PathVariable("id") String id) {
        try {
            pluginManger.uninstall(id);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResEntity.fall(e.getMessage());
        }
        return ResEntity.success();
    }

    @GetMapping("stop/{id}")
    @ResponseBody
    public ResEntity stop(@PathVariable("id") String id) {
        try {
            pluginManger.stop(id);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResEntity.fall(e.getMessage());
        }
        return ResEntity.success();
    }

    @GetMapping("start/{id}")
    @ResponseBody
    public ResEntity start(@PathVariable("id") String id) {
        try {
            pluginManger.start(id);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResEntity.fall(e.getMessage());
        }

        return ResEntity.success();
    }

    @PostMapping("update/{id}")
    @ResponseBody
    public ResEntity update(@PathVariable("id") String id, MultipartFile file) throws IOException {
        byte[] bytes = file.getBytes();
        try {
            pluginManger.update(bytes, id);
        } catch (PluginUpdateException e) {
            return ResEntity.fall(e.getMessage());
        } catch (PluginException e) {
            log.error(e.getMessage(), e);
            return ResEntity.fall(e.getMessage());
        }
        return ResEntity.success();
    }

    @GetMapping("infos")
    @ResponseBody
    public Collection<PluginDbInfo> infos(HttpServletRequest request) throws IOException {
        Collection<PluginDbInfo> values = plugDb.read().values();
        return values;
    }


}
