package cn.donting.plugin.spring.boot.starter.configuration;

import cn.donting.plugin.spring.boot.starter.*;
import cn.donting.plugin.spring.boot.starter.contorller.PluginController;
//import cn.donting.plugin.spring.boot.starter.contorller.PluginFilter;
import cn.donting.plugin.spring.boot.starter.contorller.PluginFilter;
import cn.donting.plugin.spring.boot.starter.contorller.VisitController;
import cn.donting.plugin.spring.boot.starter.dev.DevPluginLoader;
import cn.donting.plugin.spring.boot.starter.properties.PluginProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;

/**
 * @author donting
 * 2020-04-16 下午7:08
 */
@Slf4j
@Configuration
@ServletComponentScan(basePackageClasses = {PluginFilter.class})
public class PluginAutoConfiguration {


    public PluginAutoConfiguration(ListableBeanFactory beanFactory
    ) {
        log.info("plugin is starter....");
    }


    @Bean
    public DefaultPluginManger pluginManger() {
        ClassLoader classLoader = PluginAutoConfiguration.class.getClassLoader();
        try {
            //是否是web 环境
            classLoader.loadClass("javax.servlet.Servlet");
            classLoader.loadClass("org.springframework.web.context.ConfigurableWebApplicationContext");
            return new WebPluginManger();
        } catch (ClassNotFoundException e) {
            return new DefaultPluginManger();
        }
    }


    @Bean
    public PluginProperties plugProperties(ApplicationContext applicationContext) {
        return new PluginProperties(applicationContext);
    }

    @Bean
    @ConditionalOnExpression("${donting.plugin.autoPlugController:true}")
    @ConditionalOnWebApplication
    public PluginController pluginController() {
        return new PluginController();
    }

    @Bean
    @ConditionalOnWebApplication
    public VisitController visitController() {
        return new VisitController();
    }


    @Bean
    public JarPluginLoader jarPluginLoader() {
        return new JarPluginLoader();
    }

    @Bean
    @ConditionalOnExpression("'${donting.plugin.runMode}'.equals('dev')")
    public DevPluginLoader devPluginLoader() {
        log.info("-----------DEV已开启------------------");
        return new DevPluginLoader();
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnMissingBean(RequestPlugId.class)
    public RequestPlugId requestPlugId(PluginProperties pluginProperties) {
        return new DefaultRequestPlugId(pluginProperties);
    }

    @Bean
    @ConditionalOnMissingBean(PluginDb.class)
    public PluginDb pluginDb(PluginProperties pluginProperties) throws IOException {
        return new FileJsonPluginDb(pluginProperties);
    }


}
