package cn.donting.plugin.spring.boot.starter;

import cn.donting.plugin.spring.boot.starter.exception.PluginLoadException;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 *
 * 插件的加载器
 * @author donting
 */
public interface PluginLoader {
    /**
     * 根据File 加载插件
     * @param file 插件的File
     * @return PluginWrapper
     * @throws IOException 文件不存在
     * @throws PluginLoadException 插件加载异常
     */
    PluginWrapper load(File file) throws IOException, PluginLoadException;

    /**
     * 检查是否能加载
     * @param file 插件文件
     * @return 是/否
     */
    boolean isApplicable(File file);

    /**
     * 加载的插件文件验证
     * @param file File
     * @return  是/否
     * @throws FileNotFoundException 文件不存在
     * @throws PluginLoadException 插件加载异常
     */
    boolean fileInspect(File file) throws FileNotFoundException, PluginLoadException;
}
