package cn.donting.plugin.spring.boot.starter;

import java.io.File;
import java.io.IOException;
import java.util.Map;

/**
 *  插件安装信息
 * @author donting
 *  2020-05-04 上午10:27
 */
public interface PluginDb {

    /**
     * 获取所有安装的插件信息
     * @return 插件安装信息
     * @throws IOException IOException
     */
    Map<String, PluginDbInfo> read() throws IOException;

    /**
     * 卸载插件
     * @param pluginId 插件Id
     * @return 插件信息
     * @throws IOException IOException
     */
    PluginDbInfo uninstall(String pluginId) throws IOException;

    /**
     * 停止插件
     * @param pluginId 插件Id
     * @throws IOException IOException
     */
    void stop(String pluginId) throws IOException;

    /**
     * 安装插件
     * @param plugin Plugin
     * @param file 安装的文件
     * @throws IOException IOException
     */
    void install(Plugin plugin, File file) throws IOException;

    /**
     * 启动插件
     * @param pluginId 插件Id
     * @return 插件安装路径文件
     * @throws IOException IOException
     */
    String start(String pluginId) throws IOException;

    /**
     * 更新插件
     * @param plugin Plugin
     * @param file 更新后的文件
     * @throws IOException IOException
     */
    void update(Plugin plugin, File file) throws IOException;

    /**
     * 插件是否已安装
     * @param pluginId 插件Id
     * @return boolean 成功/失败
     * @throws IOException IOException
     */
    boolean isInstall(String pluginId) throws IOException;

}
