package cn.donting.plugin.spring.boot.starter;

import cn.donting.plugin.spring.boot.starter.exception.PluginLoadException;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.FileNotFoundException;

@Slf4j
public abstract class AbsPluginLoader implements PluginLoader {

    @Override
    public boolean fileInspect(File file) throws FileNotFoundException, PluginLoadException {
        if (!file.exists()) {
            log.error("file: " + file.getPath() + " is not found");
            throw new FileNotFoundException("file: " + file.getPath() + " is not found");
        }
        if (!file.isFile()) {
            log.error("file: " + file.getPath() + "is not file");
            throw new PluginLoadException("file: " + file.getPath() + "is not file", "file: " + file.getPath() + "不是文件");
        }
        return true;
    }
}
